/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.etl.tools.doc.DefaultLoadContext;
import org.openvpms.etl.tools.doc.DefaultLoaderListener;
import org.openvpms.etl.tools.doc.FileLoaderListener;
import org.openvpms.etl.tools.doc.FileStrategy;
import org.openvpms.etl.tools.doc.IdLoader;
import org.openvpms.etl.tools.doc.LoadContext;
import org.openvpms.etl.tools.doc.LoaderListener;
import org.openvpms.etl.tools.doc.LoggingLoaderListener;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.resource.i18n.Messages;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@DisallowConcurrentExecution
public class DocumentLoaderJob
implements InterruptableJob {
    private final Entity configuration;
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final JobCompletionNotifier notifier;
    private volatile boolean stop;
    private static final Logger log = LoggerFactory.getLogger(DocumentLoaderJob.class);

    public DocumentLoaderJob(Entity configuration, IArchetypeRuleService service, PlatformTransactionManager transactionManager) {
        this.configuration = configuration;
        this.service = service;
        this.transactionManager = transactionManager;
        this.notifier = new JobCompletionNotifier((IArchetypeService)service);
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        FileLoaderListener listener = null;
        try {
            IMObjectBean bean = this.service.getBean((IMObject)this.configuration);
            File source = this.getDir(bean.getString("sourceDir"));
            if (source == null || !source.exists()) {
                throw new IllegalStateException("Invalid source directory: " + source);
            }
            File target = this.getDir(bean.getString("targetDir"));
            if (target == null || !target.exists()) {
                throw new IllegalStateException("Invalid destination directory: " + target);
            }
            File error = this.getDir(bean.getString("errorDir"));
            if (error != null && !error.exists()) {
                throw new IllegalStateException("Invalid error directory: " + error);
            }
            String idPattern = bean.getString("idPattern");
            boolean overwrite = bean.getBoolean("overwrite");
            boolean recurse = bean.getBoolean("recurse");
            String[] types = bean.getString("archetypes", "").split(",");
            types = StringUtils.trimArrayElements((String[])types);
            boolean logLoad = bean.getBoolean("log");
            boolean stopOnError = bean.getBoolean("stopOnError");
            FileStrategy fileStrategy = new FileStrategy(target, error, true);
            LoggingLoaderListener delegate = logLoad ? new LoggingLoaderListener(log) : new DefaultLoaderListener();
            listener = new FileLoaderListener((LoaderListener)delegate);
            DefaultLoadContext loadContext = new DefaultLoadContext(fileStrategy, (LoaderListener)listener);
            IdLoader loader = new IdLoader(source, types, this.service, this.transactionManager, recurse, overwrite, Pattern.compile(idPattern), (LoadContext)loadContext);
            while (!this.stop && loader.hasNext() && (loader.loadNext() || !stopOnError)) {
            }
            this.complete(listener, null);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(listener, exception);
        }
    }

    public void interrupt() {
        this.stop = true;
    }

    private void complete(FileLoaderListener listener, Throwable exception) {
        Set<User> users;
        if (!((listener == null || listener.getErrors() == 0 && listener.getLoaded() == 0) && exception == null || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(listener, exception, users);
        }
    }

    private void notifyUsers(FileLoaderListener listener, Throwable exception, Set<User> users) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"docload.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"docload.exception", (Object[])new Object[]{exception.getMessage()}));
        } else {
            int loaded = listener.getLoaded();
            int errors = listener.getErrors();
            if (errors != 0) {
                reason = "ERROR";
                subject = Messages.format((String)"docload.subject.errors", (Object[])new Object[]{this.configuration.getName(), errors});
            } else {
                reason = "COMPLETED";
                subject = Messages.format((String)"docload.subject.success", (Object[])new Object[]{this.configuration.getName(), loaded});
            }
        }
        if (listener != null) {
            this.append(text, listener.getErrorFiles(), "docload.error", "docload.error.item");
            this.append(text, listener.getMissingActFiles(), "docload.missingAct", "docload.missingAct.item");
            this.append(text, listener.getAlreadyLoadedFiles(), "docload.alreadyLoaded", "docload.alreadyLoaded.item");
            this.append(text, listener.getLoadedFiles(), "docload.loaded", "docload.loaded.item");
        }
        this.notifier.send(users, subject, reason, text.toString());
    }

    private File getDir(String path) {
        return path != null ? new File(path) : null;
    }

    private <T> void append(StringBuilder text, Map<File, T> entries, String headingKey, String itemKey) {
        if (!entries.isEmpty()) {
            if (text.length() != 0) {
                text.append("\n\n");
            }
            text.append(Messages.get((String)headingKey));
            text.append("\n");
            for (Map.Entry<File, T> entry : entries.entrySet()) {
                text.append(Messages.format((String)itemKey, (Object[])new Object[]{entry.getKey(), entry.getValue()}));
                text.append("\n");
            }
        }
    }
}

