/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.scheduledreport;

import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.function.date.RelativeDateParser;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.system.common.util.ClassHelper;
import org.openvpms.report.ParameterType;
import org.openvpms.web.workspace.admin.job.scheduledreport.ExpressionType;

class ParameterEvaluator {
    ParameterEvaluator() {
    }

    public Map<String, Object> evaluate(IMObjectBean config, Set<ParameterType> parameterTypes) {
        String node;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (config.hasNode(node = "paramName" + i)) {
            String name = config.getString(node);
            if (!StringUtils.isEmpty((CharSequence)name)) {
                this.checkParameterType(parameterTypes, name);
                Object value = this.evaluate(config, i);
                result.put(name, value);
            }
            ++i;
        }
        return result;
    }

    protected LocalDate today() {
        return LocalDate.now();
    }

    protected Object evaluate(IMObjectBean config, int index) {
        Object value;
        Class<?> type = this.getClass(config.getString("paramType" + index));
        if (type != null && Date.class.isAssignableFrom(type)) {
            ExpressionType expressionType = this.getExpressionType(config, index);
            value = this.getDate(config, expressionType, index);
        } else {
            value = config.getValue("paramValue" + index);
        }
        return value;
    }

    private Date getDate(IMObjectBean config, ExpressionType expressionType, int index) {
        Date result;
        if (expressionType == ExpressionType.VALUE) {
            result = config.getDate("paramValue" + index);
        } else {
            RelativeDateParser parser;
            if (expressionType == ExpressionType.NOW) {
                result = new Date();
            } else {
                LocalDate date = this.getDate(expressionType);
                result = DateRules.toDate((LocalDate)date);
            }
            String offset = StringUtils.trimToNull((String)config.getString("paramValue" + index));
            if (offset != null && (result = (parser = new RelativeDateParser()).parse(offset, result)) == null) {
                throw new IllegalStateException("Failed to apply relative date with expression=" + offset + " to parameter " + index + "=" + config.getString("paramDisplayName" + index));
            }
        }
        return result;
    }

    private LocalDate getDate(ExpressionType expressionType) {
        LocalDate result;
        LocalDate today = this.today();
        switch (expressionType) {
            case TODAY: {
                result = today;
                break;
            }
            case YESTERDAY: {
                result = today.minusDays(1L);
                break;
            }
            case TOMORROW: {
                result = today.plusDays(1L);
                break;
            }
            case START_OF_MONTH: {
                result = today.with(TemporalAdjusters.firstDayOfMonth());
                break;
            }
            case END_OF_MONTH: {
                result = today.with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case START_OF_LAST_MONTH: {
                result = today.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
                break;
            }
            case END_OF_LAST_MONTH: {
                result = today.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case START_OF_NEXT_MONTH: {
                result = today.plusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
                break;
            }
            case END_OF_NEXT_MONTH: {
                result = today.plusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
                break;
            }
            case START_OF_YEAR: {
                result = today.with(TemporalAdjusters.firstDayOfYear());
                break;
            }
            case END_OF_YEAR: {
                result = today.with(TemporalAdjusters.lastDayOfYear());
                break;
            }
            case START_OF_LAST_YEAR: {
                result = today.with(TemporalAdjusters.firstDayOfYear()).minusYears(1L);
                break;
            }
            case END_OF_LAST_YEAR: {
                result = today.with(TemporalAdjusters.lastDayOfYear()).minusYears(1L);
                break;
            }
            case START_OF_NEXT_YEAR: {
                result = today.with(TemporalAdjusters.firstDayOfYear()).plusYears(1L);
                break;
            }
            case END_OF_NEXT_YEAR: {
                result = today.with(TemporalAdjusters.lastDayOfYear()).plusYears(1L);
                break;
            }
            case JUNE_30: {
                result = today.withMonth(6).withDayOfMonth(30);
                break;
            }
            case LAST_JUNE_30: {
                result = today.withMonth(6).withDayOfMonth(30).minusYears(1L);
                break;
            }
            case NEXT_JUNE_30: {
                result = today.withMonth(6).withDayOfMonth(30).plusYears(1L);
                break;
            }
            case JULY_1: {
                result = today.withMonth(7).withDayOfMonth(1);
                break;
            }
            case LAST_JULY_1: {
                result = today.withMonth(7).withDayOfMonth(1).minusYears(1L);
                break;
            }
            case NEXT_JULY_1: {
                result = today.withMonth(7).withDayOfMonth(1).plusYears(1L);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid argument value: " + expressionType);
            }
        }
        return result;
    }

    private ExpressionType getExpressionType(IMObjectBean config, int index) {
        return ExpressionType.valueOf((String)config.getString("paramExprType" + index, ExpressionType.VALUE.toString()));
    }

    private Class<?> getClass(String className) {
        Class type = null;
        if (!StringUtils.isEmpty((CharSequence)className)) {
            try {
                type = ClassHelper.getClass((String)className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return type;
    }

    private void checkParameterType(Set<ParameterType> parameterTypes, String name) {
        for (ParameterType type : parameterTypes) {
            if (type.isSystem() || !StringUtils.equals((CharSequence)type.getName(), (CharSequence)name)) continue;
            return;
        }
        throw new IllegalStateException("Invalid parameter " + name);
    }
}

