/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.recordlocking;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

class MedicalRecordLocker {
    private final HibernateTemplate template;
    private final PlatformTransactionManager transactionManager;

    public MedicalRecordLocker(SessionFactory factory, PlatformTransactionManager transactionManager) {
        this.template = new HibernateTemplate(factory);
        this.transactionManager = transactionManager;
    }

    public int lock(final String[] shortNames, final Date startTime, final int batchSize) {
        TransactionTemplate transaction = new TransactionTemplate(this.transactionManager);
        return (Integer)transaction.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction(TransactionStatus transactionStatus) {
                return (Integer)MedicalRecordLocker.this.template.execute(session -> {
                    int updated = 0;
                    List ids = MedicalRecordLocker.this.getIds(session, shortNames, startTime, batchSize);
                    if (!ids.isEmpty()) {
                        updated = MedicalRecordLocker.this.update(session, ids);
                    }
                    return updated;
                });
            }
        });
    }

    protected List getIds(Session session, String[] shortNames, Date startTime, int batchSize) {
        String select = "select id from org.openvpms.component.business.dao.hibernate.im.act.ActDOImpl where status <> 'POSTED' and status <> 'CANCELLED' and archetypeId.shortName in (:shortNames) and activityStartTime <= :startTime";
        Query query = session.createQuery(select);
        query.setParameterList("shortNames", Arrays.asList(shortNames));
        query.setParameter("startTime", (Object)startTime);
        query.setMaxResults(batchSize);
        return query.list();
    }

    protected int update(Session session, List ids) {
        NativeQuery update = session.createSQLQuery("update acts set status='POSTED', version=version + 1 where status <> 'POSTED' and status <> 'CANCELLED' and act_id in (:ids)");
        update.setParameterList("ids", (Collection)ids);
        return update.executeUpdate();
    }
}

