/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.docload.email;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.persistence.criteria.Expression;
import org.apache.commons.lang.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.jobs.docload.email.Email;
import org.openvpms.web.jobs.docload.email.EmailLoaderListener;
import org.openvpms.web.resource.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

class EmailLoader {
    private final Pattern pattern;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;
    private final DocumentRules rules;
    private final TransactionTemplate template;
    private final EmailLoaderListener listener;
    private static final Logger log = LoggerFactory.getLogger(EmailLoader.class);

    public EmailLoader(Pattern pattern, ArchetypeService service, PlatformTransactionManager transactionManager, DocumentHandlers handlers, DocumentRules rules, EmailLoaderListener listener) {
        this.pattern = pattern;
        this.service = service;
        this.handlers = handlers;
        this.rules = rules;
        this.listener = listener;
        this.template = new TransactionTemplate(transactionManager);
    }

    public boolean process(Email email) throws MessagingException, IOException {
        boolean result;
        Multipart parts = email.getParts();
        int attachments = 0;
        if (parts != null) {
            int processed = 0;
            boolean error = false;
            for (int i = 0; i < parts.getCount(); ++i) {
                BodyPart part = parts.getBodyPart(i);
                if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                ++attachments;
                if (this.processAttachment(part, email)) {
                    ++processed;
                    continue;
                }
                error = true;
            }
            result = attachments == 0 || !error && processed > 0;
        } else {
            result = true;
        }
        if (attachments == 0) {
            this.listener.noAttachment(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate());
        }
        return result;
    }

    private boolean processAttachment(BodyPart part, Email email) throws MessagingException {
        boolean result = false;
        String fileName = part.getFileName();
        long id = this.getId(fileName);
        if (id != -1L) {
            Boolean status = (Boolean)this.template.execute(transactionStatus -> {
                try {
                    return this.processAttachment(id, part, fileName, email);
                }
                catch (OpenVPMSException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    throw new IllegalStateException(exception.getMessage(), exception);
                }
            });
            result = status != null && status != false;
        } else {
            this.listener.missingId(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), fileName);
        }
        return result;
    }

    private boolean processAttachment(long id, BodyPart part, String fileName, Email email) throws MessagingException, IOException {
        boolean result = false;
        DocumentAct act = this.getInvestigation(id);
        if (act != null) {
            String mimeType = this.parseMimeType(part, fileName);
            if (mimeType != null) {
                result = this.addAttachment(id, part, fileName, email, act, mimeType);
            } else {
                this.listener.error(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), fileName, Messages.get((String)"emaildocload.nomimetype"));
            }
        } else {
            this.listener.missingAct(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), fileName, id);
        }
        return result;
    }

    private String parseMimeType(BodyPart part, String fileName) {
        String result = null;
        String contentType = null;
        try {
            contentType = part.getContentType();
            result = StringUtils.trimToNull((String)new ContentType(contentType).getBaseType());
            if (result != null) {
                result = result.toLowerCase();
            }
        }
        catch (Exception exception) {
            log.error("Cannot determine mime type for attachment={}: {}", new Object[]{fileName, exception.getMessage(), exception});
        }
        return result;
    }

    private boolean addAttachment(long id, BodyPart part, String fileName, Email email, DocumentAct act, String mimeType) throws MessagingException, IOException {
        boolean result;
        DocumentHandler handler = this.handlers.get(fileName, mimeType);
        try (InputStream stream = part.getInputStream();){
            Document document = handler.create(fileName, stream, mimeType, -1);
            if (!this.rules.isDuplicate(act, (org.openvpms.component.model.document.Document)document)) {
                List objects = this.rules.addDocument(act, (org.openvpms.component.model.document.Document)document);
                act.setStatus2("RECEIVED");
                this.service.save((Collection)objects);
                this.listener.loaded(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), fileName, id);
                result = true;
            } else {
                this.listener.alreadyLoaded(email.getMessageId(), email.getFrom(), email.getSubject(), email.getDate(), fileName, id);
                result = true;
            }
        }
        return result;
    }

    private DocumentAct getInvestigation(long id) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DocumentAct.class);
        Root root = query.from(DocumentAct.class, new String[]{"act.patientInvestigation"});
        query.where((Expression)builder.equal((Expression)root.get("id"), (Object)id));
        return (DocumentAct)this.service.createQuery(query).getFirstResult();
    }

    private long getId(String name) {
        Matcher matcher;
        long result = -1L;
        if (name != null && (matcher = this.pattern.matcher(name)).matches()) {
            result = Long.parseLong(matcher.group(1));
        }
        return result;
    }
}

