/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs.appointment;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.util.PeriodHelper;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.jobs.JobCompletionNotifier;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderEvaluator;
import org.openvpms.web.workspace.workflow.appointment.reminder.AppointmentReminderException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@DisallowConcurrentExecution
public class AppointmentReminderJob
implements InterruptableJob {
    private final Entity configuration;
    private final SimpleSMSService service;
    private final IArchetypeRuleService archetypeService;
    private final AppointmentRules appointmentRules;
    private final CustomerRules customerRules;
    private final PatientRules patientRules;
    private final PracticeService practiceService;
    private final LocationRules locationRules;
    private final AppointmentReminderEvaluator evaluator;
    private final PlatformTransactionManager transactionManager;
    private final Period fromPeriod;
    private final Period toPeriod;
    private final String subject;
    private final JobCompletionNotifier notifier;
    private final int maxParts;
    private final Map<Entity, Set<Date>> errors = new TreeMap<Entity, Set<Date>>((o1, o2) -> ComparatorUtils.nullLowComparator(null).compare(o1.getName(), o2.getName()));
    private volatile boolean stop;
    private Date minStartTime;
    private Date maxStartTime;
    private int total;
    private int sent;
    private static final Logger log = LoggerFactory.getLogger(AppointmentReminderJob.class);
    private static final String REASON = "APPOINTMENT_REMINDER";

    public AppointmentReminderJob(Entity configuration, SimpleSMSService service, IArchetypeRuleService archetypeService, AppointmentRules appointmentRules, CustomerRules customerRules, PatientRules patientRules, PracticeService practiceService, LocationRules locationRules, AppointmentReminderEvaluator evaluator, PlatformTransactionManager transactionManager) {
        this.configuration = configuration;
        this.service = service;
        this.archetypeService = archetypeService;
        this.appointmentRules = appointmentRules;
        this.customerRules = customerRules;
        this.patientRules = patientRules;
        this.practiceService = practiceService;
        this.locationRules = locationRules;
        this.evaluator = evaluator;
        this.transactionManager = transactionManager;
        this.maxParts = service.getMaxParts();
        IMObjectBean bean = archetypeService.getBean((IMObject)configuration);
        this.fromPeriod = PeriodHelper.getPeriod((IMObjectBean)bean, (String)"smsFrom", (String)"smsFromUnits", (DateUnits)DateUnits.WEEKS);
        this.toPeriod = PeriodHelper.getPeriod((IMObjectBean)bean, (String)"smsTo", (String)"smsToUnits", (DateUnits)DateUnits.DAYS);
        this.notifier = new JobCompletionNotifier((IArchetypeService)archetypeService);
        this.subject = Messages.get((String)"sms.log.appointment.subject");
    }

    public void interrupt() {
        this.stop = true;
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        try {
            this.execute();
            this.complete(null);
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
            this.complete(exception);
        }
    }

    protected void execute() {
        this.total = 0;
        this.sent = 0;
        Party practice = this.practiceService.getPractice();
        if (practice == null) {
            throw new IllegalStateException("No current practice");
        }
        List locations = this.practiceService.getLocations();
        Entity defaultTemplate = this.practiceService.getAppointmentSMSTemplate();
        HashMap<Party, Entity> templates = new HashMap<Party, Entity>();
        for (Party location : locations) {
            this.addTemplate(location, templates);
        }
        if (defaultTemplate == null && templates.isEmpty()) {
            throw new IllegalStateException("No Appointment Reminder SMS Templates have been configured");
        }
        NamedQuery query = new NamedQuery("AppointmentReminderJob.getReminders", new String[]{"id"});
        Date date = this.getStartDate();
        this.minStartTime = DateRules.plus((Date)date, (Period)this.toPeriod);
        this.maxStartTime = DateRules.plus((Date)date, (Period)this.fromPeriod);
        if (log.isInfoEnabled()) {
            log.info("Sending reminders for appointments between " + DateFormatter.formatDateTime((Date)this.minStartTime) + " and " + DateFormatter.formatDateTime((Date)this.maxStartTime));
        }
        query.setParameter("from", (Object)this.minStartTime);
        query.setParameter("to", (Object)this.maxStartTime);
        int pageSize = this.getPageSize();
        query.setMaxResults(pageSize);
        boolean done = false;
        HashSet<Long> exclude = new HashSet<Long>();
        while (!this.stop && !done) {
            IPage page = this.archetypeService.getObjects((IArchetypeQuery)query);
            boolean updated = false;
            for (ObjectSet set : page.getResults()) {
                long id = set.getLong("id");
                IMObjectBean bean = this.getAppointment(id);
                if (bean == null || exclude.contains(id) || !this.canSend(bean)) continue;
                ++this.total;
                if (this.send(bean, practice, defaultTemplate, templates)) {
                    ++this.sent;
                    updated = true;
                    continue;
                }
                exclude.add(id);
            }
            if (page.getResults().size() < pageSize) {
                done = true;
                continue;
            }
            if (updated) continue;
            query.setFirstResult(query.getFirstResult() + page.getResults().size());
        }
        if (log.isInfoEnabled()) {
            log.info("Sent " + this.sent + " of " + this.total + " appointment reminders");
        }
    }

    protected Date getStartDate() {
        return new Date();
    }

    protected int getPageSize() {
        return 1000;
    }

    protected boolean send(IMObjectBean bean, Party practice, Entity defaultTemplate, Map<Party, Entity> templates) {
        boolean sent = false;
        Party customer = (Party)bean.getTarget("customer", Party.class);
        if (customer != null && this.isCustomerValid(customer, bean) && this.isPatientValid(bean)) {
            Contact contact = this.customerRules.getSMSContact(customer);
            if (contact == null) {
                this.addError(bean, Messages.get((String)"sms.appointment.nocontact"));
            } else {
                Party location = this.getLocation(bean);
                if (location == null) {
                    this.addError(bean, Messages.format((String)"reporting.reminder.nolocation", (Object[])new Object[]{bean.getDisplayName()}));
                } else {
                    Entity template = templates.get(location);
                    if (template == null) {
                        template = defaultTemplate;
                    }
                    if (template == null) {
                        this.addError(bean, Messages.format((String)"sms.appointment.notemplate", (Object[])new Object[]{location.getName()}));
                    } else {
                        sent = this.send(bean, practice, customer, contact, location, template);
                    }
                }
            }
        }
        return sent;
    }

    protected boolean canSend(IMObjectBean bean) {
        return !this.isPast(bean) && bean.getBoolean("sendReminder") && bean.getDate("reminderSent") == null;
    }

    protected boolean isPast(IMObjectBean bean) {
        return DateRules.compareTo((Date)bean.getDate("startTime"), (Date)new Date()) <= 0;
    }

    protected Party getLocation(IMObjectBean bean) {
        IMObjectBean scheduleBean;
        Party location = null;
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        if (schedule != null && (location = (Party)(scheduleBean = this.archetypeService.getBean((IMObject)schedule)).getTarget("location", Policies.active())) == null) {
            log.warn("Cannot determine the practice location for: " + schedule.getName());
        }
        return location;
    }

    private boolean send(IMObjectBean bean, Party practice, Party customer, Contact contact, Party location, Entity template) {
        boolean sent;
        block6: {
            sent = false;
            Act appointment = (Act)bean.getObject(Act.class);
            try {
                String message = this.evaluator.evaluate(template, appointment, location, practice);
                if (StringUtils.isEmpty((CharSequence)message)) {
                    this.addError(bean, Messages.get((String)"reporting.reminder.emptysms"));
                } else if (this.service.getParts(message) > this.maxParts) {
                    this.addError(bean, Messages.format((String)"reporting.reminder.smstoolong", (Object[])new Object[]{message}));
                } else {
                    TransactionTemplate txnTemplate = new TransactionTemplate(this.transactionManager);
                    txnTemplate.executeWithoutResult(transactionStatus -> {
                        Party patient = (Party)bean.getTarget("patient", Party.class);
                        this.service.send(message, contact, customer, patient, this.subject, REASON, location, appointment);
                        this.appointmentRules.setSMSReminderSent(appointment, new Date());
                    });
                    sent = true;
                }
            }
            catch (AppointmentReminderException exception) {
                log.error(exception.getMessage(), (Throwable)exception);
                IMObjectBean reloaded = this.getAppointment(appointment.getId());
                if (reloaded == null) break block6;
                this.addError(reloaded, exception.getMessage());
            }
        }
        return sent;
    }

    private boolean isCustomerValid(Party customer, IMObjectBean bean) {
        boolean valid = customer.isActive();
        if (!valid) {
            this.addError(bean, Messages.get((String)"sms.appointment.customerinactive"));
        }
        return valid;
    }

    private boolean isPatientValid(IMObjectBean bean) {
        boolean valid;
        Party patient = (Party)bean.getTarget("patient", Party.class);
        if (patient == null) {
            valid = true;
        } else if (this.patientRules.isDeceased(patient)) {
            this.addError(bean, Messages.get((String)"sms.appointment.patientdeceased"));
            valid = false;
        } else if (!patient.isActive()) {
            this.addError(bean, Messages.get((String)"sms.appointment.patientinactive"));
            valid = false;
        } else {
            valid = true;
        }
        return valid;
    }

    private IMObjectBean getAppointment(long id) {
        Act act = (Act)this.archetypeService.get("act.customerAppointment", id, Act.class);
        return act != null ? this.archetypeService.getBean((IMObject)act) : null;
    }

    private void addError(IMObjectBean bean, String message) {
        log.error("Failed to send reminder, id=" + bean.getObject().getId() + ", message=" + message);
        int maxLength = bean.getMaxLength("reminderError");
        bean.setValue("reminderError", (Object)StringUtils.abbreviate((String)message, (int)maxLength));
        bean.save();
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        if (schedule != null) {
            Set dates = this.errors.computeIfAbsent(schedule, k -> new TreeSet());
            dates.add(DateRules.getDate((Date)bean.getDate("startTime")));
        }
    }

    private void addTemplate(Party location, Map<Party, Entity> templates) {
        Entity template = this.locationRules.getAppointmentSMSTemplate(location);
        if (template != null) {
            templates.put(location, template);
        }
    }

    private void complete(Throwable exception) {
        Set<User> users;
        if (!(exception == null && this.sent == 0 && this.total == 0 || (users = this.notifier.getUsers(this.configuration)).isEmpty())) {
            this.notifyUsers(users, exception);
        }
    }

    private void notifyUsers(Set<User> users, Throwable exception) {
        String subject;
        String reason;
        StringBuilder text = new StringBuilder();
        if (exception != null) {
            reason = "ERROR";
            subject = Messages.format((String)"appointmentreminder.subject.exception", (Object[])new Object[]{this.configuration.getName()});
            text.append(Messages.format((String)"appointmentreminder.exception", (Object[])new Object[]{exception.getMessage()}));
        } else if (this.sent != this.total || !this.errors.isEmpty()) {
            reason = "ERROR";
            subject = Messages.format((String)"appointmentreminder.subject.errors", (Object[])new Object[]{this.configuration.getName(), this.total - this.sent});
        } else {
            reason = "COMPLETED";
            subject = Messages.format((String)"appointmentreminder.subject.success", (Object[])new Object[]{this.configuration.getName(), this.sent});
        }
        if (this.minStartTime != null && this.maxStartTime != null) {
            text.append(Messages.format((String)"appointmentreminder.period", (Object[])new Object[]{DateFormatter.formatDateTime((Date)this.minStartTime), DateFormatter.formatDateTime((Date)this.maxStartTime)}));
            text.append("\n");
        }
        text.append(Messages.format((String)"appointmentreminder.sent", (Object[])new Object[]{this.sent, this.total}));
        if (!this.errors.isEmpty()) {
            text.append("\n\n");
            text.append(Messages.get((String)"appointmentreminder.error"));
            text.append("\n");
            for (Map.Entry<Entity, Set<Date>> entry : this.errors.entrySet()) {
                for (Date date : entry.getValue()) {
                    text.append(Messages.format((String)"appointmentreminder.error.item", (Object[])new Object[]{entry.getKey().getName(), DateFormatter.formatDate((Date)date, (boolean)false)}));
                    text.append("\n");
                }
            }
        }
        this.notifier.send(users, subject, reason, text.toString());
    }
}

