/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.jobs;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;

public class JobCompletionNotifier {
    private final IArchetypeService service;
    private final UserRules rules;

    public JobCompletionNotifier(IArchetypeService service) {
        this.service = service;
        this.rules = new UserRules(service);
    }

    public Set<User> getUsers(Entity configuration) {
        IMObjectBean bean = this.service.getBean((IMObject)configuration);
        return this.rules.getUsers(bean.getTargets("notify", Entity.class));
    }

    public void send(Set<User> users, String subject, String reason, String message) {
        for (User user : users) {
            this.send(user, subject, reason, message);
        }
    }

    protected void send(User user, String subject, String reason, String text) {
        Act act = (Act)this.service.create("act.systemMessage", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("to", (IMObject)user);
        bean.setValue("reason", (Object)reason);
        bean.setValue("description", (Object)this.truncate(subject, bean.getMaxLength("description")));
        bean.setValue("message", (Object)this.truncate(text, bean.getMaxLength("message")));
        bean.save();
    }

    private String truncate(String value, int maxLength) {
        return StringUtils.abbreviate((String)value, (int)maxLength);
    }
}

