/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Style;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.style.UserStyleSheets;

public class StyleSheetHelper {
    public static String getProperty(String name) {
        return StyleSheetHelper.getProperty(name, null);
    }

    public static String getProperty(String name, String defaultValue) {
        String result = defaultValue;
        org.openvpms.web.echo.style.Style style = StyleSheetHelper.getStyle();
        if (style != null) {
            result = style.getProperty(name, defaultValue);
        }
        return result;
    }

    public static int getNumericLength() {
        return StyleSheetHelper.getProperty("numeric.length", 14);
    }

    public static int getProperty(String name, int defaultValue) {
        int result = defaultValue;
        org.openvpms.web.echo.style.Style style = StyleSheetHelper.getStyle();
        if (style != null) {
            result = style.getProperty(name, defaultValue);
        }
        return result;
    }

    public static Font getDefaultFont() {
        Style labelStyle;
        Font result = null;
        org.openvpms.web.echo.style.Style style = StyleSheetHelper.getStyle();
        if (style != null && (labelStyle = style.getStylesheet().getStyle(Label.class, "default")) != null) {
            result = (Font)labelStyle.getProperty("font");
        }
        return result;
    }

    public static Extent getExtent(Class<?> component, String styleName, String name) {
        return (Extent)StyleSheetHelper.getProperty(component, styleName, name);
    }

    public static Insets getInsets(Class<?> component, String styleName, String name) {
        return (Insets)StyleSheetHelper.getProperty(component, styleName, name);
    }

    public static Object getProperty(Class<?> component, String styleName, String name) {
        Style s;
        Object result = null;
        org.openvpms.web.echo.style.Style style = StyleSheetHelper.getStyle();
        if (style != null && (s = style.getStylesheet().getStyle(component, styleName)) != null) {
            result = s.getProperty(name);
        }
        return result;
    }

    protected static org.openvpms.web.echo.style.Style getStyle() {
        if (ApplicationInstance.getActive() instanceof SpringApplicationInstance) {
            SpringApplicationInstance app = (SpringApplicationInstance)ApplicationInstance.getActive();
            UserStyleSheets styleSheets = (UserStyleSheets)app.getApplicationContext().getBean(UserStyleSheets.class);
            return styleSheets.getStyle();
        }
        return null;
    }
}

