/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.TaskQueueHandle;
import nextapp.echo2.webcontainer.ContainerContext;
import org.openvpms.web.echo.util.RestartableTask;
import org.openvpms.web.echo.util.TaskQueue;
import org.openvpms.web.echo.util.TaskQueues;

class RestartableTaskQueue
implements TaskQueue,
RestartableTask {
    private final WeakReference<ApplicationInstance> app;
    private final int interval;
    private final TaskQueues.QueueMode queueMode;
    private WeakReference<TaskQueueHandle> queue;
    private final List<Runnable> pending = new ArrayList<Runnable>();

    public RestartableTaskQueue(ApplicationInstance app, int interval, boolean start, TaskQueues.QueueMode queueMode) {
        this.app = new WeakReference<ApplicationInstance>(app);
        this.interval = interval;
        this.queueMode = queueMode;
        if (start) {
            this.start();
        }
    }

    @Override
    public synchronized boolean start() {
        boolean result = false;
        if (this.queue == null) {
            ApplicationInstance instance = (ApplicationInstance)this.app.get();
            if (instance != null) {
                ContainerContext context;
                TaskQueueHandle handle = instance.createTaskQueue();
                this.queue = new WeakReference<TaskQueueHandle>(handle);
                if (this.interval != 0 && (context = (ContainerContext)instance.getContextProperty(ContainerContext.CONTEXT_PROPERTY_NAME)) != null) {
                    context.setTaskQueueCallbackInterval(handle, this.interval * 1000);
                }
                ListIterator<Runnable> iterator = this.pending.listIterator();
                while (iterator.hasNext()) {
                    Runnable next = iterator.next();
                    iterator.remove();
                    instance.enqueueTask(handle, next);
                }
            }
            result = true;
        }
        return result;
    }

    @Override
    public synchronized boolean stop() {
        TaskQueueHandle handle;
        boolean stopped = false;
        if (this.queue != null && (handle = (TaskQueueHandle)this.queue.get()) != null) {
            ApplicationInstance instance = (ApplicationInstance)this.app.get();
            if (instance != null) {
                instance.removeTaskQueue(handle);
                stopped = true;
            }
            this.queue = null;
        }
        return stopped;
    }

    @Override
    public synchronized void dispose() {
        this.pending.clear();
        this.stop();
        this.app.clear();
    }

    @Override
    public synchronized boolean queue(Runnable task) {
        TaskQueueHandle handle = this.queue != null ? (TaskQueueHandle)this.queue.get() : null;
        return this.queue(task, handle, (ApplicationInstance)this.app.get());
    }

    @Override
    public synchronized boolean isRunning() {
        return this.queue != null && this.queue.get() != null;
    }

    public int getInterval() {
        return this.interval;
    }

    private boolean queue(Runnable task, TaskQueueHandle handle, ApplicationInstance instance) {
        boolean result = false;
        if (instance != null) {
            if (handle != null) {
                instance.enqueueTask(handle, task);
                result = true;
            } else {
                switch (this.queueMode) {
                    case QUEUE_ALL: {
                        this.pending.add(task);
                        result = true;
                        break;
                    }
                    case QUEUE_LAST: {
                        this.pending.clear();
                        this.pending.add(task);
                        result = true;
                        break;
                    }
                }
            }
        }
        return result;
    }
}

