/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.openvpms.web.echo.util.ApplicationInstanceRunnable;
import org.openvpms.web.echo.util.TaskQueues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicBackgroundTask {
    private final ScheduledExecutorService executor;
    private final int interval;
    private final TimeUnit units;
    private final SessionMonitor monitor;
    private final Supplier<Boolean> condition;
    private final Supplier<Boolean> task;
    private final Runnable callback;
    private final Lock lock = new ReentrantLock();
    private ApplicationInstanceRunnable callbackRunner;
    private ScheduledFuture<?> future;
    private volatile boolean updateRequired;
    private volatile boolean complete;
    private static final BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("PeriodicBackgroundTask-%d").daemon(true).build();
    private static final Logger log = LoggerFactory.getLogger(PeriodicBackgroundTask.class);

    public PeriodicBackgroundTask(int interval, TimeUnit units, SessionMonitor monitor, Supplier<Boolean> condition, Supplier<Boolean> task, Runnable callback) {
        this.interval = interval;
        this.units = units;
        this.monitor = monitor;
        this.condition = condition;
        this.task = task;
        this.callback = callback;
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)factory);
    }

    public void start() {
        this.callbackRunner = new ApplicationInstanceRunnable(this.interval / 2, TaskQueues.QueueMode.DISCARD, this::runCallback);
        this.future = this.executor.scheduleWithFixedDelay(this::runTask, this.interval, this.interval, this.units);
        this.callbackRunner.run();
    }

    public void dispose() {
        if (this.callbackRunner != null) {
            this.callbackRunner.dispose();
        }
        this.executor.shutdownNow();
    }

    private void runTask() {
        if (!this.updateRequired) {
            this.lock.lock();
            try {
                this.complete = this.isComplete();
                if (!this.complete) {
                    try {
                        Boolean status = this.task.get();
                        this.updateRequired = status != null && status != false;
                    }
                    catch (Throwable exception) {
                        log.warn("Failed to run background task: " + exception.getMessage(), exception);
                    }
                    this.complete = this.isComplete();
                }
                if (this.complete) {
                    this.future.cancel(false);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void runCallback() {
        if (this.monitor != null) {
            this.monitor.active();
        }
        if (this.updateRequired && this.lock.tryLock()) {
            try {
                this.callback.run();
            }
            catch (Throwable exception) {
                log.warn("Failed to perform UI update: " + exception.getMessage(), exception);
            }
            finally {
                this.updateRequired = false;
                this.lock.unlock();
            }
        }
        if (!this.complete) {
            this.callbackRunner.run();
        }
    }

    private boolean isComplete() {
        try {
            Boolean result = this.condition.get();
            return result != null && result != false;
        }
        catch (Throwable exception) {
            log.warn("Failed to check condition: " + exception.getMessage(), exception);
            return false;
        }
    }
}

