/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.text;

import nextapp.echo2.app.text.Document;

public abstract class TextComponent
extends nextapp.echo2.app.text.TextComponent {
    public static final String PROPERTY_CURSOR_POSITION = "cursorPosition";
    private String pending;
    private boolean haveCursorPosition;
    private boolean supportsCursorPosition = true;
    private boolean haveText;

    public TextComponent(Document document) {
        super(document);
    }

    public void processInput(String inputName, Object inputValue) {
        if ("text".equals(inputName)) {
            if (!this.supportsCursorPosition || this.haveCursorPosition) {
                this.setText((String)inputValue);
                this.haveCursorPosition = false;
            } else {
                this.pending = (String)inputValue;
                this.haveText = true;
            }
        } else if (PROPERTY_CURSOR_POSITION.equals(inputName)) {
            this.setProperty(PROPERTY_CURSOR_POSITION, inputValue);
            if (!this.commitPending()) {
                this.haveCursorPosition = true;
            }
        } else {
            if ("action".equals(inputName)) {
                this.commitPending();
                this.haveCursorPosition = false;
            }
            super.processInput(inputName, inputValue);
        }
    }

    public int getCursorPosition() {
        Integer value = (Integer)this.getProperty(PROPERTY_CURSOR_POSITION);
        return value == null ? 0 : value;
    }

    public void setCursorPosition(int position) {
        if (position < 0) {
            this.setProperty(PROPERTY_CURSOR_POSITION, null);
        } else {
            this.setProperty(PROPERTY_CURSOR_POSITION, position);
        }
    }

    protected void setSupportsCursorPosition(boolean supportsCursorPosition) {
        this.supportsCursorPosition = supportsCursorPosition;
    }

    private boolean commitPending() {
        if (this.haveText) {
            try {
                this.setText(this.pending);
            }
            finally {
                this.pending = null;
                this.haveText = false;
            }
            return true;
        }
        return false;
    }
}

