/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.layout.CellLayoutData;
import nextapp.echo2.app.layout.TableLayoutData;
import nextapp.echo2.app.list.ListSelectionModel;
import nextapp.echo2.app.table.TableColumnModel;
import nextapp.echo2.app.update.ClientUpdateManager;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.SynchronizePeerFactory;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.CellLayoutDataRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.apache.commons.io.IOUtils;
import org.openvpms.web.echo.table.KeyTable;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyTablePeer
implements ActionProcessor,
ComponentSynchronizePeer,
ImageRenderSupport,
FocusSupport,
PropertyUpdateProcessor {
    private static final String SIZING_DOTS = ". . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . ";
    private static final String[] TABLE_INIT_KEYS = new String[]{"rollover-style", "selection-style", "selection-blur-style"};
    private static final String PROPERTY_SELECTION = "selection";
    private static final String IMAGE_ID_ROLLOVER_BACKGROUND = "rolloverBackground";
    private static final String IMAGE_ID_SELECTION_BACKGROUND = "selectionBackground";
    private static final Service TABLE_SERVICE;
    protected PartialUpdateManager propertyRenderRegistry;

    public String getContainerId(Component child) {
        return ContainerInstance.getElementId((Component)child.getParent()) + "_cell_" + child.getRenderId();
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_ROLLOVER_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("rolloverBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        if (IMAGE_ID_SELECTION_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage = (FillImage)component.getRenderProperty("selectionBackgroundImage");
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return CellLayoutDataRender.getCellLayoutDataBackgroundImage((Component)component, (String)imageId);
    }

    private TableLayoutData getLayoutData(Component child) {
        LayoutData layoutData = (LayoutData)child.getRenderProperty("layoutData");
        if (layoutData == null) {
            return null;
        }
        if (layoutData instanceof TableLayoutData) {
            return (TableLayoutData)layoutData;
        }
        throw new RuntimeException("Invalid LayoutData for Table Child: " + layoutData.getClass().getName());
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        String name = actionElement.getAttribute("name");
        String value = actionElement.getAttribute("value");
        ClientUpdateManager mgr = ci.getUpdateManager().getClientUpdateManager();
        if ("page".equals(name)) {
            mgr.setComponentAction(component, "page", (Object)value);
        } else {
            mgr.setComponentAction(component, "action", null);
        }
    }

    public void renderSetFocus(RenderContext rc, Component component) {
        WindowUpdate.renderSetFocus((ServerMessage)rc.getServerMessage(), (String)(ContainerInstance.getElementId((Component)component) + "_focus"));
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if (PROPERTY_SELECTION.equals(propertyName)) {
            Element[] optionElements = DomUtil.getChildElementsByTagName((Element)propertyElement, (String)"row");
            int[] selectedIndices = new int[optionElements.length];
            for (int i = 0; i < optionElements.length; ++i) {
                selectedIndices[i] = Integer.parseInt(optionElements[i].getAttribute("index"));
            }
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, PROPERTY_SELECTION, (Object)selectedIndices);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        KeyTable table = (KeyTable)component;
        Border border = (Border)table.getRenderProperty("border");
        Insets tableInsets = (Insets)table.getRenderProperty("insets");
        String defaultInsetsAttributeValue = tableInsets == null ? "0px" : InsetsRender.renderCssAttributeValue((Insets)tableInsets);
        CssStyle styleCss = new CssStyle();
        styleCss.setAttribute("padding", defaultInsetsAttributeValue);
        BorderRender.renderToStyle((CssStyle)styleCss, (Border)border);
        DomUpdate.renderStyleSheetAddRule((ServerMessage)rc.getServerMessage(), (String)("TD.c-" + component.getRenderId()), (String)styleCss.renderInline());
        Element domAddTableElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddTableElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    private void renderAddChild(RenderContext rc, ServerComponentUpdate update, Element parentElement, Component child) {
        if (!child.isVisible()) {
            return;
        }
        ComponentSynchronizePeer syncPeer = SynchronizePeerFactory.getPeerForComponent(child.getClass());
        if (syncPeer instanceof DomUpdateSupport) {
            ((DomUpdateSupport)syncPeer).renderHtml(rc, update, (Node)parentElement, child);
        } else {
            syncPeer.renderAdd(rc, update, this.getContainerId(child), child);
        }
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(TABLE_SERVICE.getId());
        this.renderDisposeDirective(rc, (Table)component);
    }

    private void renderDisposeDirective(RenderContext rc, Table table) {
        DomUpdate.renderStyleSheetRemoveRule((ServerMessage)rc.getServerMessage(), (String)("TD.c-" + table.getRenderId()));
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "KeyTable.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)table));
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        Insets tableInsets;
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(TABLE_SERVICE.getId());
        KeyTable table = (KeyTable)component;
        this.renderInitDirective(rc, table);
        Border border = (Border)table.getRenderProperty("border");
        Extent borderSize = border == null ? null : border.getSize();
        String elementId = ContainerInstance.getElementId((Component)table);
        Document document = parentNode.getOwnerDocument();
        Element container = document.createElement("div");
        container.setAttribute("id", elementId);
        Element focus = document.createElement("a");
        focus.setAttribute("id", elementId + "_focus");
        if (component.isFocusTraversalParticipant()) {
            focus.setAttribute("tabindex", Integer.toString(component.getFocusTraversalIndex()));
        } else {
            focus.setAttribute("tabindex", "-1");
        }
        Element tableElement = document.createElement("table");
        tableElement.setAttribute("id", elementId + "_table");
        CssStyle tableCssStyle = new CssStyle();
        tableCssStyle.setAttribute("border-collapse", "collapse");
        if (((Boolean)table.getRenderProperty("selectionEnabled", Boolean.FALSE)).booleanValue()) {
            tableCssStyle.setAttribute("cursor", "pointer");
        }
        String defaultInsetsAttributeValue = (tableInsets = (Insets)table.getRenderProperty("insets")) == null ? "0px" : InsetsRender.renderCssAttributeValue((Insets)tableInsets);
        ColorRender.renderToStyle((CssStyle)tableCssStyle, (Component)component);
        FontRender.renderToStyle((CssStyle)tableCssStyle, (Component)component);
        BorderRender.renderToStyle((CssStyle)tableCssStyle, (Border)border);
        if (borderSize != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkCssBorderCollapseInside")) {
            tableCssStyle.setAttribute("margin", ExtentRender.renderCssAttributeValueHalf((Extent)borderSize));
        }
        Extent width = (Extent)table.getRenderProperty("width");
        boolean render100PercentWidthWorkaround = false;
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkIETablePercentWidthScrollbarError") && width != null && width.getUnits() == 2 && width.getValue() == 100) {
            width = null;
            render100PercentWidthWorkaround = true;
        }
        ExtentRender.renderToStyle((CssStyle)tableCssStyle, (String)"width", (Extent)width);
        tableElement.setAttribute("style", tableCssStyle.renderInline());
        parentNode.appendChild(container);
        container.appendChild(focus);
        container.appendChild(tableElement);
        TableColumnModel columnModel = table.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        boolean someColumnsHaveWidths = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnModel.getColumn(i).getWidth() == null) continue;
            someColumnsHaveWidths = true;
        }
        if (someColumnsHaveWidths) {
            Element colGroupElement = document.createElement("colgroup");
            tableElement.appendChild(colGroupElement);
            for (int i = 0; i < columnCount; ++i) {
                Element colElement = document.createElement("col");
                Extent columnWidth = columnModel.getColumn(i).getWidth();
                if (columnWidth != null) {
                    colElement.setAttribute("width", ExtentRender.renderCssAttributeValue((Extent)columnWidth));
                }
                colGroupElement.appendChild(colElement);
            }
        }
        Element firstTrElement = null;
        if (table.isHeaderVisible()) {
            Element theadElement = document.createElement("thead");
            theadElement.setAttribute("id", elementId + "_thead");
            tableElement.appendChild(theadElement);
            firstTrElement = this.renderRow(rc, update, theadElement, table, -1, defaultInsetsAttributeValue);
        }
        Element tbodyElement = document.createElement("tbody");
        tbodyElement.setAttribute("id", elementId + "_tbody");
        tableElement.appendChild(tbodyElement);
        int rows = table.getModel().getRowCount();
        for (int rowIndex = 0; rowIndex < rows; ++rowIndex) {
            if (firstTrElement == null && rowIndex == 0) {
                firstTrElement = this.renderRow(rc, update, tbodyElement, table, rowIndex, defaultInsetsAttributeValue);
                continue;
            }
            this.renderRow(rc, update, tbodyElement, table, rowIndex, defaultInsetsAttributeValue);
        }
        if (render100PercentWidthWorkaround && firstTrElement != null) {
            NodeList childNodes = firstTrElement.getChildNodes();
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                if (!"td".equals(childNodes.item(i).getNodeName())) continue;
                Element tdElement = (Element)childNodes.item(i);
                Element sizingDivElement = document.createElement("div");
                sizingDivElement.setAttribute("style", "font-size:50px;height:0px;overflow:hidden;");
                sizingDivElement.appendChild(document.createTextNode(SIZING_DOTS));
                tdElement.appendChild(sizingDivElement);
            }
        }
    }

    private void renderInitDirective(RenderContext rc, KeyTable table) {
        String elementId = ContainerInstance.getElementId((Component)table);
        ServerMessage serverMessage = rc.getServerMessage();
        Document document = serverMessage.getDocument();
        boolean rolloverEnabled = (Boolean)table.getRenderProperty("rolloverEnabled", Boolean.FALSE);
        boolean selectionEnabled = (Boolean)table.getRenderProperty("selectionEnabled", Boolean.FALSE);
        String rolloverStyle = "";
        if (rolloverEnabled) {
            CssStyle rolloverCssStyle = new CssStyle();
            ColorRender.renderToStyle((CssStyle)rolloverCssStyle, (Color)((Color)table.getRenderProperty("rolloverForeground")), (Color)((Color)table.getRenderProperty(IMAGE_ID_ROLLOVER_BACKGROUND)));
            FontRender.renderToStyle((CssStyle)rolloverCssStyle, (Font)((Font)table.getRenderProperty("rolloverFont")));
            FillImageRender.renderToStyle((CssStyle)rolloverCssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)table, (String)IMAGE_ID_ROLLOVER_BACKGROUND, (FillImage)((FillImage)table.getRenderProperty("rolloverBackgroundImage")), (int)1);
            if (rolloverCssStyle.hasAttributes()) {
                rolloverStyle = rolloverCssStyle.renderInline();
            }
        }
        String selectionStyle = "";
        String selectionBlurStyle = "";
        if (selectionEnabled) {
            CssStyle selectionCssStyle = new CssStyle();
            ColorRender.renderToStyle((CssStyle)selectionCssStyle, (Color)((Color)table.getRenderProperty("selectionForeground")), (Color)((Color)table.getRenderProperty(IMAGE_ID_SELECTION_BACKGROUND)));
            FontRender.renderToStyle((CssStyle)selectionCssStyle, (Font)((Font)table.getRenderProperty("selectionFont")));
            FillImageRender.renderToStyle((CssStyle)selectionCssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)table, (String)IMAGE_ID_SELECTION_BACKGROUND, (FillImage)((FillImage)table.getRenderProperty("selectionBackgroundImage")), (int)1);
            if (selectionCssStyle.hasAttributes()) {
                selectionStyle = selectionCssStyle.renderInline();
            }
            CssStyle selectionBlurCssStyle = new CssStyle();
            ColorRender.renderToStyle((CssStyle)selectionBlurCssStyle, (Color)((Color)table.getRenderProperty("selectionBlurForeground")), (Color)((Color)table.getRenderProperty("selectionBlurBackground")));
            FontRender.renderToStyle((CssStyle)selectionBlurCssStyle, (Font)((Font)table.getRenderProperty("selectionBlurFont")));
            FillImageRender.renderToStyle((CssStyle)selectionCssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)table, (String)IMAGE_ID_SELECTION_BACKGROUND, (FillImage)((FillImage)table.getRenderProperty("selectionBackgroundImage")), (int)1);
            if (selectionBlurCssStyle.hasAttributes()) {
                selectionBlurStyle = selectionBlurCssStyle.renderInline();
            }
        }
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "KeyTable.MessageProcessor", "init", TABLE_INIT_KEYS, new String[]{rolloverStyle, selectionStyle, selectionBlurStyle});
        Element itemElement = document.createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (table.isHeaderVisible()) {
            itemElement.setAttribute("header-visible", "true");
        }
        if (table.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        if (table.hasPageListeners()) {
            itemElement.setAttribute("server-page-notify", "true");
        }
        if (rolloverEnabled) {
            itemElement.setAttribute("rollover-enabled", "true");
        }
        if (selectionEnabled) {
            itemElement.setAttribute("selection-enabled", "true");
            ListSelectionModel selectionModel = table.getSelectionModel();
            if (selectionModel.getSelectionMode() == 2) {
                itemElement.setAttribute("selection-mode", "multiple");
            }
            if (selectionModel.getMinSelectedIndex() != -1) {
                Element selectionElement = document.createElement(PROPERTY_SELECTION);
                int minimumIndex = selectionModel.getMinSelectedIndex();
                int maximumIndex = selectionModel.getMaxSelectedIndex();
                if (maximumIndex > table.getModel().getRowCount() - 1) {
                    maximumIndex = table.getModel().getRowCount() - 1;
                }
                for (int i = minimumIndex; i <= maximumIndex; ++i) {
                    if (!selectionModel.isSelectedIndex(i)) continue;
                    Element rowElement = document.createElement("row");
                    rowElement.setAttribute("index", Integer.toString(i));
                    selectionElement.appendChild(rowElement);
                }
                itemElement.appendChild(selectionElement);
            }
        }
        if (!table.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    private Element renderRow(RenderContext rc, ServerComponentUpdate update, Element tbodyElement, KeyTable table, int rowIndex, String defaultInsetsAttributeValue) {
        Document document = tbodyElement.getOwnerDocument();
        String elementId = ContainerInstance.getElementId((Component)table);
        Element trElement = document.createElement("tr");
        if (rowIndex == -1) {
            trElement.setAttribute("id", elementId + "_tr_header");
        } else {
            trElement.setAttribute("id", elementId + "_tr_" + rowIndex);
        }
        tbodyElement.appendChild(trElement);
        String className = "c-" + table.getRenderId();
        boolean inlineStyleRequired = rc.getContainerInstance().getClientProperties().getBoolean("notSupportedCssManipulation");
        Border border = (Border)table.getRenderProperty("border");
        int columns = table.getColumnModel().getColumnCount();
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            Component childComponent = table.getCellComponent(columnIndex, rowIndex);
            Element tdElement = rowIndex != -1 ? document.createElement("td") : document.createElement("th");
            tdElement.setAttribute("id", elementId + "_cell_" + childComponent.getRenderId());
            CssStyle tdCssStyle = new CssStyle();
            if (rowIndex == -1 && table.isHeaderFixed()) {
                tdCssStyle.setAttribute("position", "sticky");
                if (border != null) {
                    tdCssStyle.setAttribute("top", "-" + border.getSize());
                }
                tdCssStyle.setAttribute("background-clip", "padding-box");
            }
            if (inlineStyleRequired || rowIndex == -1) {
                BorderRender.renderToStyle((CssStyle)tdCssStyle, (Border)border);
            }
            if (inlineStyleRequired) {
                CellLayoutDataRender.renderToElementAndStyle((Element)tdElement, (CssStyle)tdCssStyle, (Component)childComponent, (CellLayoutData)this.getLayoutData(childComponent), (String)defaultInsetsAttributeValue);
            } else {
                tdElement.setAttribute("class", className);
                CellLayoutDataRender.renderToElementAndStyle((Element)tdElement, (CssStyle)tdCssStyle, (Component)childComponent, (CellLayoutData)this.getLayoutData(childComponent), null);
            }
            CellLayoutDataRender.renderBackgroundImageToStyle((CssStyle)tdCssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)table, (Component)childComponent);
            if (tdCssStyle.hasAttributes()) {
                String value = tdCssStyle.renderInline();
                if (rowIndex == -1 && table.isHeaderFixed()) {
                    value = "position:-webkit-sticky;" + value;
                }
                tdElement.setAttribute("style", value);
            }
            trElement.appendChild(tdElement);
            this.renderAddChild(rc, update, tdElement, childComponent);
        }
        return trElement;
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        Table table = (Table)update.getParent();
        this.renderDisposeDirective(rc, table);
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)table));
        this.renderAdd(rc, update, targetId, (Component)table);
        return true;
    }

    static {
        InputStream stream = KeyTablePeer.class.getResourceAsStream("/org/openvpms/web/echo/js/KeyTable.js");
        try {
            String content = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            TABLE_SERVICE = new JavaScriptService("KeyTable", content);
            WebRenderServlet.getServiceRegistry().add(TABLE_SERVICE);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }
}

