/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.keyboard;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeyStrokeMask {
    private int code = 4096;
    private static final Log log = LogFactory.getLog(KeyStrokeMask.class);

    public void setMask(String mask) {
        int code = 0;
        StringTokenizer tokens = new StringTokenizer(mask, "-");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("Ctrl".equalsIgnoreCase(token)) {
                code |= 0x2000;
                continue;
            }
            if ("Alt".equalsIgnoreCase(token)) {
                code |= 0x1000;
                continue;
            }
            if ("Shift".equalsIgnoreCase(token)) {
                code |= 0x4000;
                continue;
            }
            log.warn((Object)("Unsupported key=" + token + " in mask=" + mask));
        }
        if (code != 0) {
            this.code = code;
        }
    }

    public int getKeyCode(char key) {
        return this.code | key;
    }
}

