/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.keyboard;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.WindowPane;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;
import org.openvpms.web.echo.keyboard.KeyStrokeMask;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.springframework.context.ApplicationContext;

public class KeyStrokeHelper {
    private static final KeyStrokeMask DEFAULT_MASK = new KeyStrokeMask();

    public static void reregisterKeyStrokeListeners() {
        Component component;
        Window root = ApplicationInstance.getActive().getDefaultWindow();
        KeyStrokeHelper.reregisterKeyStrokeListeners((Component)root);
        for (component = FocusHelper.getFocus(); component != null && component != root; component = component.getParent()) {
        }
        if (component != root) {
            FocusHelper.setFocus((Component)root);
        }
    }

    public static void reregisterKeyStrokeListeners(Component component) {
        if (component instanceof KeyStrokeHandler) {
            ((KeyStrokeHandler)component).reregisterKeyStrokeListeners();
        }
        for (Component child : component.getComponents()) {
            if (child instanceof WindowPane) continue;
            KeyStrokeHelper.reregisterKeyStrokeListeners(child);
        }
    }

    public static int getKeyCode(char key) {
        KeyStrokeMask mask = null;
        if (ApplicationInstance.getActive() instanceof SpringApplicationInstance) {
            SpringApplicationInstance app = (SpringApplicationInstance)SpringApplicationInstance.getActive();
            ApplicationContext context = app.getApplicationContext();
            mask = (KeyStrokeMask)context.getBean("keyStrokeMask");
        }
        if (mask == null) {
            mask = DEFAULT_MASK;
        }
        return mask.getKeyCode(key);
    }
}

