/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.AbstractListComponent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.list.KeyListBox;

public class SelectionDialog
extends ModalDialog {
    private final AbstractListComponent list;
    private Object selected;
    private int index = -1;
    private boolean closeOnSelection = true;
    private static final String STYLE = "SelectionDialog";

    public SelectionDialog(String title, String message, List<?> list) {
        this(title, message, (ListModel)new DefaultListModel(list.toArray()));
    }

    public SelectionDialog(String title, String message, ListModel list) {
        this(title, message, new KeyListBox(list));
    }

    public SelectionDialog(String title, String message, ListBox list) {
        this(title, message, list, null);
    }

    public SelectionDialog(String title, String message, ListBox list, HelpContext help) {
        super(title, STYLE, OK_CANCEL, help);
        this.list = list;
        if (list.getSelectedValue() == null && list.getModel().size() != 0) {
            list.getSelectionModel().setSelectedIndex(0, true);
        }
        this.list.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                SelectionDialog.this.onSelected();
            }
        });
        Label prompt = LabelFactory.create(true, true);
        prompt.setStyleName("bold");
        prompt.setText(message);
        Column column = ColumnFactory.create("CellSpacing", new Component[]{prompt, this.list});
        this.getLayout().add((Component)ColumnFactory.create("Inset", new Component[]{column}));
        this.getFocusGroup().add((Component)list);
        FocusHelper.setFocus((Component)list);
    }

    public Object getSelected() {
        return this.selected;
    }

    public int getSelectedIndex() {
        return this.index;
    }

    protected void setCloseOnSelection(boolean closeOnSelection) {
        this.closeOnSelection = closeOnSelection;
    }

    protected void onSelected() {
        this.index = this.list.getSelectionModel().getMinSelectedIndex();
        Object object = this.selected = this.index != -1 ? this.list.getModel().get(this.index) : null;
        if (this.closeOnSelection) {
            this.close("ok");
        }
    }

    @Override
    protected void onOK() {
        this.onSelected();
    }
}

