/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.WindowPane;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.DialogManager;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.echo.keyboard.KeyStrokeHelper;
import org.openvpms.web.echo.pane.ContentPane;
import org.openvpms.web.echo.util.StyleSheetHelper;

public abstract class PopupWindow
extends WindowPane {
    private final SplitPane layout;
    private final ButtonRow row;
    private final FocusGroup focusGroup;
    private ContentPane root;
    private String defaultButton;
    private boolean doneLayout = false;

    public PopupWindow(String title) {
        this(title, null, null);
    }

    public PopupWindow(String title, String style, FocusGroup focus) {
        super(title, null, null);
        if (style == null) {
            style = "PopupWindow";
        }
        this.setStyleName(style);
        this.focusGroup = new FocusGroup(((Object)((Object)this)).getClass().getName());
        if (focus != null) {
            this.focusGroup.add(focus);
        }
        this.row = new ButtonRow(this.focusGroup, "DialogButtonRow", "default");
        this.root = new ContentPane();
        this.layout = this.createSplitPane();
        this.layout.add((Component)this.row);
        this.root.add((Component)this.layout);
        this.add((Component)this.root);
    }

    public void setContentWidth(int width) {
        int adjust = StyleSheetHelper.getProperty("dialog.margins", 0);
        this.setWidth(new Extent(width + adjust));
    }

    public void setContentHeight(int height) {
        int adjust = StyleSheetHelper.getProperty("dialog.title.height", 0) + StyleSheetHelper.getProperty("splitpane-buttonrow.separatorPosition", 0) + StyleSheetHelper.getProperty("dialog.margins", 0);
        this.setHeight(new Extent(height + adjust));
    }

    public void show() {
        this.show(false);
    }

    public void show(boolean top) {
        if (!this.doneLayout) {
            this.doLayout();
            this.doneLayout = true;
        }
        if (this.getParent() == null) {
            DialogManager.show(this, top);
        }
        if (this.defaultButton != null) {
            this.getButtons().setFocus(this.defaultButton);
        }
    }

    public void setDefaultButton(String id) {
        this.defaultButton = id;
    }

    public String getDefaultButton() {
        return this.defaultButton;
    }

    public void close() {
        if (this.getParent() != null) {
            this.userClose();
        }
    }

    public ButtonSet getButtons() {
        return this.row.getButtons();
    }

    public void userClose() {
        this.fireWindowClosing();
        Integer defaultCloseOperationValue = (Integer)this.getRenderProperty("defaultCloseOperation");
        int defaultCloseOperation = defaultCloseOperationValue == null ? 2 : defaultCloseOperationValue;
        switch (defaultCloseOperation) {
            case 2: {
                if (this.getParent() == null) break;
                this.getParent().remove((Component)this);
                break;
            }
            case 1: {
                this.setVisible(false);
            }
        }
    }

    protected ContentPane getContentPane() {
        return this.root;
    }

    protected SplitPane createSplitPane() {
        return SplitPaneFactory.create(6, "PopupWindow.Layout", new Component[0]);
    }

    protected void doLayout() {
    }

    protected SplitPane getLayout() {
        return this.layout;
    }

    protected Button addButton(String id, Runnable listener) {
        return this.addButton(id, false, listener);
    }

    protected Button addButton(String id, boolean disableShortcut, Runnable listener) {
        return this.row.addButton(id, disableShortcut, listener);
    }

    protected FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected void fireWindowClosing() {
        this.reregisterKeyStrokeListeners();
        super.fireWindowClosing();
    }

    protected void reregisterKeyStrokeListeners() {
        ApplicationInstance active = ApplicationInstance.getActive();
        if (active != null) {
            WindowPane next = null;
            Window root = active.getDefaultWindow();
            for (Component c : root.getContent().getComponents()) {
                WindowPane pane;
                if (!(c instanceof WindowPane) || !(pane = (WindowPane)c).isModal() || pane == this || next != null && pane.getZIndex() <= next.getZIndex()) continue;
                next = pane;
            }
            if (next != null) {
                KeyStrokeHelper.reregisterKeyStrokeListeners(next);
            } else {
                KeyStrokeHelper.reregisterKeyStrokeListeners((Component)root);
            }
        }
    }

    protected void setFocus(Component component) {
        FocusHelper.setFocus(component);
    }
}

