/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import nextapp.echo2.app.event.WindowPaneEvent;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.WindowPaneListener;

public abstract class PopupDialogListener
extends WindowPaneListener {
    @Override
    public void onClose(WindowPaneEvent event) {
        if (event.getSource() instanceof PopupDialog) {
            PopupDialog dialog = (PopupDialog)((Object)event.getSource());
            try {
                this.onAction(dialog);
            }
            catch (Throwable exception) {
                ErrorHandler.getInstance().error(exception);
            }
        }
    }

    public void onOK() {
        this.onAction("ok");
    }

    public void onCancel() {
        this.onAction("cancel");
    }

    public void onYes() {
        this.onAction("yes");
    }

    public void onNo() {
        this.onAction("no");
    }

    public void onSkip() {
        this.onAction("skip");
    }

    public void onApply() {
        this.onAction("apply");
    }

    public void onRetry() {
        this.onAction("retry");
    }

    public void onAction(String action) {
    }

    protected void onAction(PopupDialog dialog) {
        String action = dialog.getAction();
        if ("ok".equals(action)) {
            this.onOK();
        } else if ("cancel".equals(action)) {
            this.onCancel();
        } else if ("yes".equals(action)) {
            this.onYes();
        } else if ("no".equals(action)) {
            this.onNo();
        } else if ("skip".equals(action)) {
            this.onSkip();
        } else if ("apply".equals(action)) {
            this.onApply();
        } else if ("retry".equals(action)) {
            this.onRetry();
        } else {
            this.onAction(action);
        }
    }
}

