/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import echopointng.PopUp;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ContentPane;
import nextapp.echo2.app.Window;
import nextapp.echo2.app.WindowPane;
import nextapp.echo2.app.event.WindowPaneEvent;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupWindow;
import org.openvpms.web.echo.event.WindowPaneListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.util.TaskQueues;

public class DialogManager {
    public static void show(PopupWindow dialog) {
        DialogManager.show(dialog, false);
    }

    public static void show(final PopupWindow dialog, boolean forceToTop) {
        ApplicationInstance instance = ApplicationInstance.getActive();
        ContentPane root = DialogManager.getDefaultWindowContentPane(instance);
        if (root != null) {
            SpringApplicationInstance springApplicationInstance;
            TaskQueues tasks;
            int lastIndex = 1000;
            int zIndex = 0;
            ErrorDialog error = null;
            for (Component component : root.getComponents()) {
                if (component instanceof WindowPane) {
                    FocusGroup group;
                    WindowPane pane = (WindowPane)component;
                    if (pane.getZIndex() > zIndex) {
                        zIndex = pane.getZIndex();
                    }
                    if (pane instanceof PopupWindow && (group = ((PopupWindow)pane).getFocusGroup()).getLast() > lastIndex) {
                        lastIndex = group.getLast();
                    }
                    if (pane instanceof ErrorDialog && (error == null || error.getZIndex() < pane.getZIndex())) {
                        error = (ErrorDialog)pane;
                    }
                }
                DialogManager.hideAlwaysOnTopPopups(component);
            }
            dialog.setZIndex(zIndex + 1);
            FocusGroup group = dialog.getFocusGroup();
            if (group.getFirst() <= lastIndex) {
                group.reindex(lastIndex + 1000);
            }
            if (instance instanceof SpringApplicationInstance && (tasks = (springApplicationInstance = (SpringApplicationInstance)instance).getTaskQueues()).suspend(dialog)) {
                dialog.addWindowPaneListener(new WindowPaneListener(){

                    @Override
                    public void onClose(WindowPaneEvent event) {
                        tasks.resume(dialog);
                    }
                });
            }
            root.add((Component)dialog);
            if (!forceToTop && error != null && !(dialog instanceof ErrorDialog)) {
                DialogManager.moveErrorToTop(error, dialog);
            }
        }
    }

    public static boolean isWindowDisplayed() {
        ContentPane root = DialogManager.getDefaultWindowContentPane();
        if (root != null) {
            for (Component component : root.getComponents()) {
                if (!(component instanceof WindowPane)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isHidden(Component component) {
        ContentPane root;
        WindowPane parent = DialogManager.getWindowPane(component);
        if (parent != null && (root = DialogManager.getDefaultWindowContentPane()) != null) {
            for (Component c : root.getComponents()) {
                WindowPane pane;
                if (!(c instanceof WindowPane) || !(pane = (WindowPane)c).isModal() || pane.getZIndex() <= parent.getZIndex()) continue;
                return true;
            }
        }
        return false;
    }

    protected static WindowPane getWindowPane(Component component) {
        while (component != null && !(component instanceof WindowPane)) {
            component = component.getParent();
        }
        return (WindowPane)component;
    }

    protected static ContentPane getDefaultWindowContentPane() {
        return DialogManager.getDefaultWindowContentPane(ApplicationInstance.getActive());
    }

    private static void hideAlwaysOnTopPopups(Component component) {
        if (component instanceof PopUp) {
            PopUp popup = (PopUp)component;
            if (popup.isExpanded() && popup.getPopUpAlwaysOnTop()) {
                popup.setExpanded(false);
            }
        } else {
            for (Component child : component.getComponents()) {
                DialogManager.hideAlwaysOnTopPopups(child);
            }
        }
    }

    private static void moveErrorToTop(ErrorDialog error, PopupWindow dialog) {
        error.setZIndex(dialog.getZIndex() + 1);
        error.setModal(false);
        error.setModal(true);
    }

    private static ContentPane getDefaultWindowContentPane(ApplicationInstance active) {
        Window root;
        ContentPane result = null;
        if (active != null && (root = active.getDefaultWindow()) != null) {
            result = root.getContent();
        }
        return result;
    }
}

