/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.date;

import echopointng.DateChooser;
import echopointng.DateField;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.WebRenderServlet;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.function.date.RelativeDateParser;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public class DateFieldImpl
extends DateField {
    private boolean allowNulls = false;

    public DateFieldImpl() {
        DateFormat edit = DateFormatter.getDateFormat((boolean)true);
        DateFormat view = DateFormatter.getDateFormat((boolean)false);
        DelegatingDateFormat format = new DelegatingDateFormat(edit, view, null);
        this.setDateFormat(format);
        this.setPopUpAlwaysOnTop(true);
        this.getTextField().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            @Override
            public void onAction(ActionEvent e) {
            }
        });
        DateChooser chooser = new DateChooser(){

            public void processInput(String inputName, Object inputValue) {
                Connection connection;
                if ("displayedDate".equals(inputName) && (connection = WebRenderServlet.getActiveConnection()) != null && "true".equals(connection.getProperty(DateFieldImpl.this.getDateUpdatedPropertyKey()))) {
                    return;
                }
                super.processInput(inputName, inputValue);
            }
        };
        chooser.setSelectedDate(chooser.getSelectedDate());
        this.setDateChooser(chooser);
    }

    public void setAllowNulls(boolean allow) {
        this.allowNulls = allow;
    }

    public void setRelativeDate(Date date) {
        DateFormat format = this.getDateFormat();
        if (format instanceof DelegatingDateFormat) {
            ((DelegatingDateFormat)format).setRelativeDate(date);
        }
    }

    protected void updateDateFromText() {
        if (this.isUpdateFromTextField()) {
            if (StringUtils.isEmpty((CharSequence)this.getText()) && this.allowNulls) {
                this.getDateChooser().setSelectedDate(null);
            } else {
                super.updateDateFromText();
            }
            this.updateTextFromDate();
            Connection connection = WebRenderServlet.getActiveConnection();
            if (connection != null) {
                connection.setProperty(this.getDateUpdatedPropertyKey(), (Object)"true");
            }
        }
    }

    private String getDateUpdatedPropertyKey() {
        return this.getRenderId() + ".dateUpdated";
    }

    private static class DelegatingDateFormat
    extends DateFormat {
        private static final RelativeDateParser parser = new RelativeDateParser();
        private final DateFormat edit;
        private final DateFormat view;
        private Date date;

        public DelegatingDateFormat(DateFormat edit, DateFormat view, Date date) {
            this.edit = edit;
            this.view = view;
            this.date = date;
        }

        public void setRelativeDate(Date date) {
            this.date = date;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.view.format(date, toAppendTo, fieldPosition);
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            return this.edit.parse(source, pos);
        }

        @Override
        public Date parse(String source) throws ParseException {
            Date result = parser.parse(source, this.date);
            if (result == null) {
                result = this.edit.parse(source);
            }
            return result;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return this.edit.parseObject(source, pos);
        }

        @Override
        public void setCalendar(Calendar newCalendar) {
            this.edit.setCalendar(newCalendar);
            this.view.setCalendar(newCalendar);
        }

        @Override
        public Calendar getCalendar() {
            return this.edit.getCalendar();
        }

        @Override
        public void setNumberFormat(NumberFormat newNumberFormat) {
            this.edit.setNumberFormat(newNumberFormat);
            this.view.setNumberFormat(newNumberFormat);
        }

        @Override
        public NumberFormat getNumberFormat() {
            return this.edit.getNumberFormat();
        }

        @Override
        public void setTimeZone(TimeZone zone) {
            this.edit.setTimeZone(zone);
            this.view.setTimeZone(zone);
        }

        @Override
        public TimeZone getTimeZone() {
            return this.edit.getTimeZone();
        }

        @Override
        public void setLenient(boolean lenient) {
            this.edit.setLenient(lenient);
        }

        @Override
        public boolean isLenient() {
            return this.edit.isLenient();
        }
    }
}

