/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;

public class ButtonColumn
extends Column
implements KeyStrokeHandler {
    private final ButtonSet set;
    private static final String STYLE = "ControlColumn";

    public ButtonColumn() {
        this(STYLE, null);
    }

    public ButtonColumn(String columnStyle, String buttonStyle) {
        this(null, columnStyle, buttonStyle);
    }

    public ButtonColumn(FocusGroup focus) {
        this(focus, STYLE, null);
    }

    public ButtonColumn(FocusGroup focus, String columnStyle, String buttonStyle) {
        this.setStyleName(columnStyle);
        this.set = new ButtonSet((Component)this, focus, buttonStyle);
    }

    public ButtonSet getButtons() {
        return this.set;
    }

    public Button addButton() {
        return this.set.add();
    }

    public Button addButton(String key) {
        return this.set.add(key);
    }

    public Button addButton(String key, nextapp.echo2.app.event.ActionListener listener) {
        return this.set.add(key, listener);
    }

    public Button addButton(String key, boolean disableShortcut, final Runnable listener) {
        return this.addButton(key, disableShortcut, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public Button addButton(String key, boolean disableShortcut, nextapp.echo2.app.event.ActionListener listener) {
        return this.set.add(key, disableShortcut, listener);
    }

    public void removeButton(Button button) {
        this.set.remove((AbstractButton)button);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component instanceof Button) {
            this.removeButton((Button)component);
        }
    }

    @Override
    public void reregisterKeyStrokeListeners() {
        this.set.reregisterKeyStrokeListeners();
    }
}

