/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import echopointng.KeyStrokeListener;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;

public abstract class AbstractKeystrokeHandler
implements KeyStrokeHandler {
    private final Component container;
    private KeyStrokeListener listener;
    private Map<String, ActionListener> handlers = new HashMap<String, ActionListener>();

    public AbstractKeystrokeHandler(Component container) {
        this.container = container;
    }

    public KeyStrokeListener getKeyStrokeListener() {
        return this.listener;
    }

    public void addListener(int keyCode, ActionListener listener) {
        String key = Integer.toString(keyCode);
        this.addKey(keyCode, key);
        this.handlers.put(key, listener);
    }

    public void removeListener(int keyCode) {
        this.removeKey(keyCode);
        this.handlers.remove(Integer.toString(keyCode));
    }

    public void processInput(ActionEvent event) {
        this.handleKey(event);
    }

    protected abstract void onKeyStroke(ActionEvent var1);

    protected void addKey(int keyCode, String actionCommand) {
        this.getListener().addKeyCombination(keyCode, actionCommand);
    }

    protected void removeKey(int keyCode) {
        if (this.listener != null) {
            this.listener.removeKeyCombination(keyCode);
        }
    }

    private void handleKey(ActionEvent event) {
        ActionListener listener = this.handlers.get(event.getActionCommand());
        if (listener != null) {
            listener.actionPerformed(event);
        } else {
            this.onKeyStroke(event);
        }
    }

    private KeyStrokeListener getListener() {
        if (this.listener == null) {
            this.listener = new KeyStrokeListener();
            this.listener.setCancelMode(true);
            this.listener.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    AbstractKeystrokeHandler.this.handleKey(event);
                }
            });
            this.container.add((Component)this.listener);
        } else if (this.container.indexOf((Component)this.listener) == -1) {
            this.container.add((Component)this.listener);
        }
        return this.listener;
    }
}

