/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;

public class WeakReferenceCallbacks {
    private final List<WeakReference<Runnable>> callbacks = Collections.synchronizedList(new ArrayList());

    public void add(Runnable callback) {
        this.callbacks.add(new WeakReference<Runnable>(callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Runnable callback) {
        List<WeakReference<Runnable>> list = this.callbacks;
        synchronized (list) {
            ListIterator<WeakReference<Runnable>> iterator = this.callbacks.listIterator();
            while (iterator.hasNext()) {
                WeakReference<Runnable> ref = iterator.next();
                Runnable delegate = (Runnable)ref.get();
                if (delegate != null && !Objects.equals(callback, delegate)) continue;
                iterator.remove();
            }
        }
    }

    public void call() {
        ArrayList<WeakReference<Runnable>> copy = new ArrayList<WeakReference<Runnable>>(this.callbacks);
        ListIterator<WeakReference<Runnable>> iterator = copy.listIterator();
        while (iterator.hasNext()) {
            WeakReference<Runnable> ref = iterator.next();
            Runnable delegate = (Runnable)ref.get();
            if (delegate != null) {
                delegate.run();
                continue;
            }
            iterator.remove();
        }
    }
}

