/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import echopointng.LabelEx;
import echopointng.xhtml.XhtmlFragment;
import java.util.function.Function;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import nextapp.echo2.app.table.TableCellRenderer;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableHelper;

public abstract class AbstractTableCellRenderer
implements TableCellRenderer {
    private final Function<Object, Object> formatter;

    public AbstractTableCellRenderer() {
        this(null);
    }

    public AbstractTableCellRenderer(Function<Object, Object> formatter) {
        this.formatter = formatter;
    }

    public Component getTableCellRendererComponent(Table table, Object value, int column, int row) {
        Component component = this.getComponent(table, value, column, row);
        String style = this.getStyle(table, value, column, row);
        if (style != null) {
            this.mergeStyle(component, style);
        }
        return component;
    }

    protected String getStyle(Table table, Object value, int column, int row) {
        return null;
    }

    protected Component getComponent(Table table, Object value, int column, int row) {
        Component component;
        if (this.formatter != null) {
            try {
                value = this.formatter.apply(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (value instanceof Component) {
            component = (Component)value;
        } else if (value != null) {
            Label label = LabelFactory.create();
            label.setText(value.toString());
            component = label;
        } else {
            component = new LabelEx(new XhtmlFragment("<div>&#160;</div>"));
        }
        return component;
    }

    protected void mergeStyle(Component component, String styleName) {
        this.mergeStyle(component, styleName, false);
    }

    protected void mergeStyle(Component component, String styleName, boolean overwrite) {
        TableHelper.mergeStyle(component, styleName, overwrite);
    }
}

