/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.style.Theme;
import org.openvpms.web.echo.style.Themes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ThemeResources
implements Themes {
    private final Map<String, Theme> themes = new HashMap<String, Theme>();
    private static final Logger log = LoggerFactory.getLogger(ThemeResources.class);

    public ThemeResources() {
        this.load();
    }

    @Override
    public synchronized Theme getTheme(String id) {
        return this.themes.get(id);
    }

    @Override
    public synchronized Map<String, Theme> getThemes() {
        return Collections.unmodifiableMap(this.themes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        HashMap<String, Theme> map = new HashMap<String, Theme>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources;
            for (Resource resource : resources = resolver.getResources("classpath*:style/theme-*.properties")) {
                String id = this.getId(resource);
                if (id == null) continue;
                this.load(id, resource, map);
            }
        }
        catch (IOException exception) {
            log.warn("Failed to load themes: {}", (Object)exception.getMessage(), (Object)exception);
        }
        if (!map.isEmpty()) {
            ThemeResources themeResources = this;
            synchronized (themeResources) {
                this.themes.clear();
                this.themes.putAll(map);
            }
        }
    }

    private String getId(Resource resource) {
        String id = null;
        String fileName = resource.getFilename();
        if (fileName != null) {
            fileName = fileName.toLowerCase();
            id = StringUtils.substringAfter((String)fileName.toLowerCase(), (String)"theme-");
            id = StringUtils.substringBefore((String)id, (String)".properties");
            id = StringUtils.trimToNull((String)id);
        }
        return id;
    }

    private void load(String id, Resource resource, Map<String, Theme> themes) {
        Properties properties = new Properties();
        try (InputStream stream = resource.getInputStream();){
            HashMap<String, String> map = new HashMap<String, String>();
            properties.load(stream);
            String name = null;
            for (String key : properties.stringPropertyNames()) {
                if ("name".equals(key)) {
                    name = (String)properties.get(key);
                    continue;
                }
                map.put(key, (String)properties.get(key));
            }
            if (name == null) {
                name = id;
            }
            themes.put(id, new Theme(id, name, map));
        }
        catch (IOException exception) {
            log.warn("Failed to load theme from {}: {}", new Object[]{resource.getFilename(), exception.getMessage(), exception});
        }
    }
}

