/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.io.IOException;
import java.util.Map;
import org.openvpms.web.echo.style.StyleSheetProperties;
import org.openvpms.web.echo.style.StyleSheetResources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStyleSheetProperties
implements StyleSheetProperties {
    private final String defaultName;
    private final String overrideName;
    private final Map<String, String> properties;
    private static final Logger log = LoggerFactory.getLogger(ResourceStyleSheetProperties.class);

    public ResourceStyleSheetProperties(String defaultName, String overrideName) throws IOException {
        this.defaultName = defaultName;
        this.overrideName = overrideName;
        this.properties = StyleSheetResources.getProperties(defaultName + ".properties", true);
        if (overrideName != null) {
            String name = overrideName + ".properties";
            Map<String, String> overrides = StyleSheetResources.getProperties(name, false);
            if (overrides != null) {
                log.info("Overriding default stylesheet properties using " + name);
                this.properties.putAll(overrides);
            } else {
                log.info("No style overrides found for: " + name);
            }
        }
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public String getOverrideName() {
        return this.overrideName;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

