/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.awt.Dimension;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nextapp.echo2.app.StyleSheet;
import org.openvpms.web.echo.style.Style;
import org.openvpms.web.echo.style.StylePropertyEvaluator;
import org.openvpms.web.echo.style.StyleSheets;

public abstract class AbstractStyleSheetCache
implements StyleSheets {
    private final Map<Dimension, Map<String, String>> resolutions = new HashMap<Dimension, Map<String, String>>();
    private final Map<Dimension, Map<String, String>> evaluatedResolutions = new HashMap<Dimension, Map<String, String>>();
    private final Map<Dimension, Style> stylesheets = new HashMap<Dimension, Style>();
    private StylePropertyEvaluator evaluator;

    @Override
    public Style getStyle(int width, int height) {
        Dimension size = new Dimension(width, height);
        return this.getStyle(size);
    }

    @Override
    public StyleSheet getStyleSheet(int width, int height) {
        return this.getStyle(width, height).getStylesheet();
    }

    @Override
    public Style getStyle(Dimension size) {
        Style result = this.getCachedStyleSheet(size);
        if (result == null) {
            Map<String, String> properties = this.getProperties(size, true);
            result = new Style(this.getStyleSheet(properties), size, properties);
            this.stylesheets.put(size, result);
        }
        return result;
    }

    @Override
    public synchronized StyleSheet getStyleSheet(Dimension size) {
        return this.getStyle(size).getStylesheet();
    }

    @Override
    public synchronized Map<String, String> getDefaultProperties() {
        return this.evaluator.getDefaultProperties();
    }

    @Override
    public Map<String, String> getProperties(int width, int height) {
        return this.getProperties(width, height, true);
    }

    @Override
    public Map<String, String> getProperties(int width, int height, boolean evaluate) {
        return this.getProperties(new Dimension(width, height), evaluate);
    }

    @Override
    public synchronized Map<String, String> getProperties(Dimension size, boolean evaluate) {
        Map<String, String> properties;
        if (evaluate) {
            properties = this.evaluatedResolutions.get(size);
            if (properties == null) {
                Map<String, String> closest = this.getClosestResolution(size);
                properties = this.evaluator.getProperties(size.width, size.height, closest);
                properties = Collections.unmodifiableMap(properties);
                this.evaluatedResolutions.put(size, properties);
            }
        } else {
            Map<String, String> closest = this.getClosestResolution(size);
            properties = new HashMap<String, String>(this.getDefaultProperties());
            if (closest != null) {
                properties.putAll(closest);
            }
        }
        return properties;
    }

    @Override
    public synchronized Map<String, String> evaluate(Map<String, String> properties, int width, int height) {
        return this.evaluator.getProperties(width, height, properties);
    }

    @Override
    public synchronized Dimension[] getResolutions() {
        return this.sortResolutions(this.resolutions.keySet());
    }

    @Override
    public synchronized Map<String, String> getResolution(Dimension size) {
        return this.resolutions.get(size);
    }

    protected synchronized void setDefaultProperties(Map<String, String> properties) {
        this.evaluator = new StylePropertyEvaluator(properties);
    }

    protected synchronized void addResolution(Dimension size, Map<String, String> properties) {
        this.resolutions.put(size, Collections.unmodifiableMap(properties));
        this.evaluatedResolutions.remove(size);
        this.stylesheets.remove(size);
    }

    protected synchronized void removeResolution(Dimension size) {
        this.resolutions.remove(size);
        this.evaluatedResolutions.remove(size);
        this.stylesheets.remove(size);
    }

    protected Map<Dimension, Map<String, String>> getAllResolutions() {
        return this.resolutions;
    }

    protected synchronized Map<String, String> getClosestResolution(Dimension size) {
        Map<String, String> result = this.getResolution(size);
        if (result == null) {
            Dimension best = null;
            for (Dimension resolution : this.getResolutions()) {
                if (resolution.width > size.width && best != null) break;
                if (best == null) {
                    best = resolution;
                    continue;
                }
                if (best.width == resolution.width && resolution.height > size.height) continue;
                best = resolution;
            }
            result = best != null ? this.getResolution(best) : null;
        }
        return result;
    }

    protected synchronized void clearCache() {
        this.stylesheets.clear();
        this.evaluatedResolutions.clear();
    }

    protected Style getCachedStyleSheet(int width, int height) {
        return this.getCachedStyleSheet(new Dimension(width, height));
    }

    protected synchronized Style getCachedStyleSheet(Dimension size) {
        return this.stylesheets.get(size);
    }

    protected synchronized boolean hasResolution(Dimension size) {
        return this.resolutions.containsKey(size);
    }

    protected Dimension[] sortResolutions(Set<Dimension> resolutions) {
        Comparator<Dimension> comparator = new Comparator<Dimension>(){

            @Override
            public int compare(Dimension o1, Dimension o2) {
                int result = o1.width - o2.width;
                if (result == 0) {
                    result = o1.height - o2.height;
                }
                return result;
            }
        };
        TreeSet<Dimension> result = new TreeSet<Dimension>(comparator);
        result.addAll(resolutions);
        return result.toArray(new Dimension[0]);
    }
}

