/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SessionListener
implements HttpSessionListener {
    public void sessionCreated(HttpSessionEvent event) {
        SessionMonitor monitor = this.getSessionMonitor(event);
        monitor.addSession(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SessionMonitor monitor = this.getSessionMonitor(event);
        monitor.removeSession(event.getSession());
    }

    private SessionMonitor getSessionMonitor(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)session.getServletContext());
        return (SessionMonitor)ctx.getBean(SessionMonitor.class);
    }
}

