/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.palette;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.ListBox;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.collections.ListUtils;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.ListBoxFactory;

public class Palette<T>
extends Row {
    private final List<T> items;
    private final List<T> unselected = new ArrayList<T>();
    private final List<T> selected = new ArrayList<T>();
    private ListBox unselectedList;
    private ListBox selectedList;
    private Button add;
    private Button remove;

    public Palette(List<T> items, List<T> selected) {
        this.setStyleName("Palette");
        this.items = items;
        this.setSelected(selected);
        this.doLayout();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.unselectedList.setCellRenderer(renderer);
        this.selectedList.setCellRenderer(renderer);
    }

    public void setFocusTraversalIndex(int newValue) {
        this.unselectedList.setFocusTraversalIndex(newValue);
        this.selectedList.setFocusTraversalIndex(newValue);
        this.add.setFocusTraversalIndex(newValue);
        this.remove.setFocusTraversalIndex(newValue);
    }

    public List<T> getItems() {
        return this.items;
    }

    protected void doLayout() {
        int mode = 2;
        this.unselectedList = ListBoxFactory.create(this.unselected);
        this.unselectedList.setSelectionMode(2);
        this.selectedList = ListBoxFactory.create(this.selected);
        this.selectedList.setSelectionMode(2);
        if (!this.unselected.isEmpty()) {
            this.selectedList.getSelectionModel().clearSelection();
        }
        this.add = ButtonFactory.create("right_add", this::onAdd);
        this.remove = ButtonFactory.create("left_remove", this::onRemove);
        Label available = this.createAvailableLabel();
        Label selected = this.createSelectedLabel();
        Column left = ColumnFactory.create("Palette.ListColumn", new Component[]{available, this.unselectedList});
        Column middle = ColumnFactory.create("ControlColumn", new Component[]{this.add, this.remove});
        Column right = ColumnFactory.create("Palette.ListColumn", new Component[]{selected, this.selectedList});
        this.add((Component)left);
        this.add((Component)middle);
        this.add((Component)right);
    }

    protected void setSelected(List<T> list) {
        this.selected.clear();
        this.selected.addAll(list);
        this.unselected.clear();
        this.unselected.addAll(ListUtils.subtract(this.items, this.selected));
        this.sort(this.selected);
        this.sort(this.unselected);
        if (this.selectedList != null && this.unselectedList != null) {
            this.selectedList.setModel((ListModel)new DefaultListModel(this.selected.toArray()));
            this.unselectedList.setModel((ListModel)new DefaultListModel(this.unselected.toArray()));
        }
    }

    protected void onAdd() {
        Object[] values = this.unselectedList.getSelectedValues();
        this.move(this.unselectedList, this.selectedList);
        this.add(values);
    }

    protected void onRemove() {
        Object[] values = this.selectedList.getSelectedValues();
        this.move(this.selectedList, this.unselectedList);
        this.remove(values);
    }

    protected void add(Object[] values) {
    }

    protected void remove(Object[] values) {
    }

    protected void move(ListBox from, ListBox to) {
        Object[] values = from.getSelectedValues();
        DefaultListModel fromModel = (DefaultListModel)from.getModel();
        List<T> toValues = this.getValues(to.getModel());
        for (int index : from.getSelectedIndices()) {
            from.setSelectedIndex(index, false);
        }
        Object[] objectArray = values;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object value;
            Object object = value = objectArray[i];
            fromModel.remove(value);
            toValues.add(object);
        }
        this.sort(toValues);
        DefaultListModel defaultListModel = new DefaultListModel(toValues.toArray());
        to.setModel((ListModel)defaultListModel);
        int[] selected = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            selected[i] = defaultListModel.indexOf(values[i]);
        }
        to.setSelectedIndices(selected);
    }

    protected void sort(List<T> values) {
    }

    protected Label createAvailableLabel() {
        return this.createLabel("label.available");
    }

    protected Label createSelectedLabel() {
        return this.createLabel("label.selected");
    }

    protected Label createLabel(String key) {
        return LabelFactory.create(key, "Palette.ListLabel");
    }

    private List<T> getValues(ListModel model) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < model.size(); ++i) {
            result.add(model.get(i));
        }
        return result;
    }
}

