/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.error;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.web.echo.error.ErrorHandler;

public class LoggingErrorHandler
extends ErrorHandler {
    static final ErrorHandler INSTANCE = new LoggingErrorHandler();
    private static final Log log = LogFactory.getLog(LoggingErrorHandler.class);

    @Override
    public void error(Throwable cause) {
        log.error((Object)cause.getMessage(), cause);
    }

    @Override
    public void error(String title, String message, boolean html, Throwable cause, Runnable listener) {
        if (html) {
            message = StringEscapeUtils.unescapeHtml4((String)message);
        }
        log.error((Object)message, cause);
        if (listener != null) {
            listener.run();
        }
    }
}

