/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.dialog.DialogManager;
import org.openvpms.web.echo.dialog.PopupWindow;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.VetoListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.util.StyleSheetHelper;

public abstract class PopupDialog
extends PopupWindow {
    public static final String OK_ID = "ok";
    public static final String CLOSE_ID = "close";
    public static final String APPLY_ID = "apply";
    public static final String CANCEL_ID = "cancel";
    public static final String YES_ID = "yes";
    public static final String NO_ID = "no";
    public static final String SKIP_ID = "skip";
    public static final String RETRY_ID = "retry";
    public static final String[] OK = new String[]{"ok"};
    public static final String[] CLOSE = new String[]{"close"};
    public static final String[] CANCEL = new String[]{"cancel"};
    public static final String[] OK_CANCEL = new String[]{"ok", "cancel"};
    public static final String[] OK_SKIP_CANCEL = new String[]{"ok", "skip", "cancel"};
    public static final String[] OK_SKIP = new String[]{"ok", "skip"};
    public static final String[] SKIP_CANCEL = new String[]{"skip", "cancel"};
    public static final String[] YES_NO = new String[]{"yes", "no"};
    public static final String[] YES_NO_CANCEL = new String[]{"yes", "no", "cancel"};
    public static final String[] APPLY_OK_CANCEL = new String[]{"apply", "ok", "cancel"};
    public static final String[] RETRY_CANCEL = new String[]{"retry", "cancel"};
    private final HelpContext help;
    private String action;
    private VetoListener<Vetoable> cancelListener;
    private VetoListener<Vetoable> skipListener;
    private String defaultCloseAction;

    public PopupDialog(String title, String[] buttons) {
        this(title, null, buttons);
    }

    public PopupDialog(String title, String[] buttons, HelpContext help) {
        this(title, null, buttons, help);
    }

    public PopupDialog(String title, String style, String[] buttons) {
        this(title, style, buttons, null);
    }

    public PopupDialog(String title, String style, String[] buttons, HelpContext help) {
        this(title, style, buttons, help, null);
    }

    public PopupDialog(String title, String style, String[] buttons, HelpContext help, FocusGroup focus) {
        super(title, style, focus);
        this.help = help;
        for (String button : buttons) {
            this.addButton(button, false);
        }
        if (buttons.length != 0) {
            this.defaultCloseAction = buttons[buttons.length - 1];
        }
        if (help != null) {
            this.getButtons().addKeyListener(help.getKeyCode(), new ActionListener(){

                @Override
                public void onAction(ActionEvent event) {
                    PopupDialog.this.onHelp();
                }
            });
        }
    }

    public String getAction() {
        return this.action;
    }

    public void setCancelListener(VetoListener<Vetoable> listener) {
        this.cancelListener = listener;
    }

    public void setSkipListener(VetoListener<Vetoable> listener) {
        this.skipListener = listener;
    }

    public void setDefaultCloseAction(String action) {
        this.defaultCloseAction = action;
    }

    @Override
    public void userClose() {
        if (this.action == null && this.defaultCloseAction != null) {
            this.onButtonProtected(this.defaultCloseAction);
        } else {
            this.onClosing();
            super.userClose();
        }
    }

    public HelpContext getHelpContext() {
        return this.help;
    }

    public void close(String action) {
        this.setAction(action);
        this.close();
    }

    public boolean resize(String property) {
        boolean resized = false;
        int width = -1;
        int height = -1;
        String size = StyleSheetHelper.getProperty(property);
        if (size != null) {
            String[] values = size.split("x");
            if (values.length == 2) {
                try {
                    width = Integer.parseInt(values[0]);
                    height = Integer.parseInt(values[1]);
                    int fontSize = StyleSheetHelper.getProperty("font.size", -1);
                    width *= fontSize;
                    height *= fontSize;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (width > 0 && height > 0) {
                this.setWidth(new Extent(width));
                this.setHeight(new Extent(height));
                resized = true;
            }
        }
        return resized;
    }

    protected void setAction(String action) {
        this.action = action;
    }

    protected void onButton(String button) {
        try {
            if (OK_ID.equals(button)) {
                this.onOK();
            } else if (CLOSE_ID.equals(button)) {
                this.onClose();
            } else if (CANCEL_ID.equals(button)) {
                this.onCancel();
            } else if (YES_ID.equals(button)) {
                this.onYes();
            } else if (NO_ID.equals(button)) {
                this.onNo();
            } else if (SKIP_ID.equals(button)) {
                this.onSkip();
            } else if (APPLY_ID.equals(button)) {
                this.onApply();
            } else if (RETRY_ID.equals(button)) {
                this.onRetry();
            } else {
                this.setAction(button);
                this.close();
            }
        }
        catch (Throwable exception) {
            ErrorHandler.getInstance().error(exception);
        }
    }

    protected void onOK() {
        this.close(OK_ID);
    }

    protected void onClose() {
        this.close(CLOSE_ID);
    }

    protected void onCancel() {
        if (this.cancelListener != null) {
            this.cancelListener.onVeto(veto -> {
                if (!veto) {
                    this.doCancel();
                }
            });
        } else {
            this.doCancel();
        }
    }

    protected void doCancel() {
        this.close(CANCEL_ID);
    }

    protected void onYes() {
        this.close(YES_ID);
    }

    protected void onNo() {
        this.close(NO_ID);
    }

    protected void onSkip() {
        if (this.skipListener != null) {
            this.skipListener.onVeto(veto -> {
                if (!veto) {
                    this.doSkip();
                }
            });
        } else {
            this.doSkip();
        }
    }

    protected void doSkip() {
        this.close(SKIP_ID);
    }

    protected void onApply() {
        this.close(APPLY_ID);
    }

    protected void onRetry() {
        this.close(RETRY_ID);
    }

    protected void onHelp() {
        HelpContext help = this.getHelpContext();
        if (help != null) {
            help.show();
        }
    }

    protected void onClosing() {
    }

    protected Button addButton(String id) {
        return this.addButton(id, false);
    }

    protected Button addButton(String id, boolean disableShortcut) {
        return this.addButton(id, disableShortcut, () -> this.onButtonProtected(id));
    }

    protected void resize() {
        String styleName = this.getStyleName();
        if (styleName != null) {
            this.resize(styleName + ".size");
        }
    }

    private void onButtonProtected(String id) {
        if (!DialogManager.isHidden((Component)this)) {
            try {
                this.onButton(id);
            }
            catch (Throwable exception) {
                ErrorHandler.getInstance().error(exception);
            }
        }
    }
}

