/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.echo.button.AbstractKeystrokeHandler;
import org.openvpms.web.echo.button.ShortcutButton;

public class ShortcutButtons
extends AbstractKeystrokeHandler {
    private Map<String, ShortcutButton> buttons = new HashMap<String, ShortcutButton>();
    private static final Log log = LogFactory.getLog(ShortcutButtons.class);

    public ShortcutButtons(Component container) {
        super(container);
    }

    public void add(ShortcutButton button) {
        this.buttons.put(button.getActionCommand(), button);
        this.addKeyStrokeListener(button);
    }

    public void remove(ShortcutButton button) {
        this.buttons.remove(button.getActionCommand());
        this.removeKeystrokeListener(button);
    }

    @Override
    public void reregisterKeyStrokeListeners() {
        for (ShortcutButton button : this.buttons.values()) {
            this.removeKeystrokeListener(button);
            this.addKeyStrokeListener(button);
        }
    }

    @Override
    protected void onKeyStroke(ActionEvent event) {
        String command = event.getActionCommand();
        if (command != null) {
            Button button = (Button)this.buttons.get(command);
            if (button != null && button.isEnabled()) {
                ActionEvent buttonEvent = new ActionEvent((Object)button, command);
                button.fireActionPerformed(buttonEvent);
            } else {
                log.debug((Object)("Keystroke received but not handled, actionCommand=" + command));
            }
        } else {
            log.warn((Object)"Keystroke received but not handled");
        }
    }

    private void addKeyStrokeListener(ShortcutButton button) {
        int code = button.getKeyCode();
        if (code != -1) {
            this.addKey(code, button.getActionCommand());
        }
    }

    private void removeKeystrokeListener(ShortcutButton button) {
        int code = button.getKeyCode();
        if (code != -1) {
            this.removeKey(code);
        }
    }
}

