/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.text;

import java.util.Locale;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Border;
import nextapp.echo2.app.Color;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.FillImage;
import nextapp.echo2.app.Font;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.LayoutDirection;
import nextapp.echo2.app.text.TextComponent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ComponentSynchronizePeer;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.DomUpdateSupport;
import nextapp.echo2.webcontainer.FocusSupport;
import nextapp.echo2.webcontainer.PartialUpdateManager;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.image.ImageRenderSupport;
import nextapp.echo2.webcontainer.partialupdate.BorderUpdate;
import nextapp.echo2.webcontainer.partialupdate.ColorUpdate;
import nextapp.echo2.webcontainer.partialupdate.InsetsUpdate;
import nextapp.echo2.webcontainer.propertyrender.AlignmentRender;
import nextapp.echo2.webcontainer.propertyrender.BorderRender;
import nextapp.echo2.webcontainer.propertyrender.ColorRender;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webcontainer.propertyrender.FillImageRender;
import nextapp.echo2.webcontainer.propertyrender.FontRender;
import nextapp.echo2.webcontainer.propertyrender.InsetsRender;
import nextapp.echo2.webcontainer.propertyrender.LayoutDirectionRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.servermessage.WindowUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import nextapp.echo2.webrender.util.DomUtil;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.util.ExtentHelper;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TextComponentPeer
implements ActionProcessor,
ComponentSynchronizePeer,
DomUpdateSupport,
FocusSupport,
ImageRenderSupport,
PropertyUpdateProcessor {
    private static final String IMAGE_ID_BACKGROUND = "background";
    public static final Service TEXT_COMPONENT_SERVICE = JavaScriptService.forResource((String)"Echo.TextComponent", (String)"/org/openvpms/web/echo/js/TextComponent.js");
    private PartialUpdateManager partialUpdateManager = new PartialUpdateManager();

    public TextComponentPeer() {
        this.partialUpdateManager.add("foreground", (PartialUpdateParticipant)new ColorUpdate("foreground", null, "color"));
        this.partialUpdateManager.add(IMAGE_ID_BACKGROUND, (PartialUpdateParticipant)new ColorUpdate(IMAGE_ID_BACKGROUND, null, "backgroundColor"));
        this.partialUpdateManager.add("border", (PartialUpdateParticipant)new BorderUpdate("border", null, "border"));
        this.partialUpdateManager.add("insets", (PartialUpdateParticipant)new InsetsUpdate("insets", null, "padding"));
        this.partialUpdateManager.add("text", (PartialUpdateParticipant)new TextUpdate());
        this.partialUpdateManager.add("cursorPosition", (PartialUpdateParticipant)new CursorPositionUpdate());
    }

    protected CssStyle createBaseCssStyle(RenderContext rc, TextComponent textComponent) {
        Alignment alignment;
        Color foreground;
        Font font;
        Border border;
        FillImage backgroundImage;
        Color background;
        CssStyle cssStyle = new CssStyle();
        boolean renderEnabled = textComponent.isRenderEnabled();
        if (!renderEnabled) {
            background = (Color)textComponent.getRenderProperty("disabledBackground");
            backgroundImage = (FillImage)textComponent.getRenderProperty("disabledBackgroundImage");
            border = (Border)textComponent.getRenderProperty("disabledBorder");
            font = (Font)textComponent.getRenderProperty("disabledFont");
            foreground = (Color)textComponent.getRenderProperty("disabledForeground");
            if (background == null) {
                background = (Color)textComponent.getRenderProperty(IMAGE_ID_BACKGROUND);
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)textComponent.getRenderProperty("backgroundImage");
                }
            }
            if (border == null) {
                border = (Border)textComponent.getRenderProperty("border");
            }
            if (font == null) {
                font = (Font)textComponent.getRenderProperty("font");
            }
            if (foreground == null) {
                foreground = (Color)textComponent.getRenderProperty("foreground");
            }
        } else {
            border = (Border)textComponent.getRenderProperty("border");
            foreground = (Color)textComponent.getRenderProperty("foreground");
            background = (Color)textComponent.getRenderProperty(IMAGE_ID_BACKGROUND);
            font = (Font)textComponent.getRenderProperty("font");
            backgroundImage = (FillImage)textComponent.getRenderProperty("backgroundImage");
        }
        if ((alignment = (Alignment)textComponent.getRenderProperty("alignment")) != null) {
            int horizontalAlignment = AlignmentRender.getRenderedHorizontal((Alignment)alignment, (Component)textComponent);
            switch (horizontalAlignment) {
                case 3: {
                    cssStyle.setAttribute("text-align", "left");
                    break;
                }
                case 4: {
                    cssStyle.setAttribute("text-align", "center");
                    break;
                }
                case 5: {
                    cssStyle.setAttribute("text-align", "right");
                }
            }
        }
        LayoutDirectionRender.renderToStyle((CssStyle)cssStyle, (LayoutDirection)textComponent.getLayoutDirection(), (Locale)textComponent.getLocale());
        BorderRender.renderToStyle((CssStyle)cssStyle, (Border)border);
        ColorRender.renderToStyle((CssStyle)cssStyle, (Color)foreground, (Color)background);
        FontRender.renderToStyle((CssStyle)cssStyle, (Font)font);
        FillImageRender.renderToStyle((CssStyle)cssStyle, (RenderContext)rc, (ImageRenderSupport)this, (Component)textComponent, (String)IMAGE_ID_BACKGROUND, (FillImage)backgroundImage, (int)1);
        InsetsRender.renderToStyle((CssStyle)cssStyle, (String)"padding", (Insets)((Insets)textComponent.getRenderProperty("insets")));
        Extent width = (Extent)textComponent.getRenderProperty("width");
        Extent height = (Extent)textComponent.getRenderProperty("height");
        if (width != null) {
            cssStyle.setAttribute("width", ExtentRender.renderCssAttributeValue((Extent)width));
        }
        if (height != null) {
            cssStyle.setAttribute("height", ExtentRender.renderCssAttributeValue((Extent)height));
        }
        return cssStyle;
    }

    public String getContainerId(Component child) {
        throw new UnsupportedOperationException("Component does not support children.");
    }

    public ImageReference getImage(Component component, String imageId) {
        if (IMAGE_ID_BACKGROUND.equals(imageId)) {
            FillImage backgroundImage;
            if (component.isRenderEnabled()) {
                backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
            } else {
                backgroundImage = (FillImage)component.getRenderProperty("disabledBackgroundImage");
                if (backgroundImage == null) {
                    backgroundImage = (FillImage)component.getRenderProperty("backgroundImage");
                }
            }
            if (backgroundImage == null) {
                return null;
            }
            return backgroundImage.getImage();
        }
        return null;
    }

    public void processAction(ContainerInstance ci, Component component, Element actionElement) {
        ci.getUpdateManager().getClientUpdateManager().setComponentAction(component, "action", null);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        String propertyName = propertyElement.getAttribute("name");
        if ("text".equals(propertyName)) {
            String propertyValue = DomUtil.getElementText((Element)propertyElement);
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "text", (Object)propertyValue);
        } else if ("horizontalScroll".equals(propertyName)) {
            Extent propertyValue = ExtentHelper.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "horizontalScroll", (Object)propertyValue);
        } else if ("verticalScroll".equals(propertyName)) {
            Extent propertyValue = ExtentHelper.toExtent(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "verticalScroll", (Object)propertyValue);
        } else if ("cursorPosition".equals(propertyName)) {
            int propertyValue = Integer.parseInt(propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "cursorPosition", (Object)propertyValue);
        }
    }

    public void renderAdd(RenderContext rc, ServerComponentUpdate update, String targetId, Component component) {
        Element domAddElement = DomUpdate.renderElementAdd((ServerMessage)rc.getServerMessage());
        DocumentFragment htmlFragment = rc.getServerMessage().getDocument().createDocumentFragment();
        this.renderHtml(rc, update, htmlFragment, component);
        DomUpdate.renderElementAddContent((ServerMessage)rc.getServerMessage(), (Element)domAddElement, (String)targetId, (DocumentFragment)htmlFragment);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(TEXT_COMPONENT_SERVICE.getId());
        this.renderDisposeDirective(rc, (TextComponent)component);
    }

    public void renderDisposeDirective(RenderContext rc, TextComponent textComponent) {
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "EchoTextComponent.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderInitDirective(RenderContext rc, TextComponent textComponent) {
        Integer cursorPos;
        String value;
        Integer maximumLength;
        Extent horizontalScroll = (Extent)textComponent.getRenderProperty("horizontalScroll");
        Extent verticalScroll = (Extent)textComponent.getRenderProperty("verticalScroll");
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoTextComponent.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributePixelValue((Extent)horizontalScroll, (String)"0"));
        }
        if (verticalScroll != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributePixelValue((Extent)verticalScroll, (String)"0"));
        }
        if (textComponent instanceof TextArea && (maximumLength = (Integer)textComponent.getProperty("maximumLength")) != null) {
            itemElement.setAttribute("maximum-length", maximumLength.toString());
        }
        if (textComponent instanceof TextArea && rc.getContainerInstance().getClientProperties().getBoolean("quirkTextareaContent") && (value = textComponent.getText()) != null) {
            itemElement.setAttribute("text", value);
        }
        if ((cursorPos = (Integer)textComponent.getRenderProperty("cursorPosition")) != null) {
            itemElement.setAttribute("cursor-position", cursorPos.toString());
        }
        if (!textComponent.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        if (textComponent.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    public void renderSetFocus(RenderContext rc, Component component) {
        WindowUpdate.renderSetFocus((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)component));
    }

    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        boolean fullReplace = false;
        if (update.hasUpdatedProperties() && !this.partialUpdateManager.canProcess(rc, update)) {
            fullReplace = true;
        }
        if (fullReplace) {
            DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)ContainerInstance.getElementId((Component)update.getParent()));
            this.renderAdd(rc, update, targetId, update.getParent());
        } else {
            this.partialUpdateManager.process(rc, update);
        }
        return false;
    }

    static {
        new DummyPeer();
        WebRenderServlet.getServiceRegistry().remove(TEXT_COMPONENT_SERVICE);
        WebRenderServlet.getServiceRegistry().add(TEXT_COMPONENT_SERVICE);
    }

    private class CursorPositionUpdate
    implements PartialUpdateParticipant {
        private CursorPositionUpdate() {
        }

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            TextComponent textComponent = (TextComponent)update.getParent();
            String elementId = ContainerInstance.getElementId((Component)textComponent);
            ServerMessage serverMessage = rc.getServerMessage();
            Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoTextComponent.MessageProcessor", "set-cursor-position", new String[0], new String[0]);
            Element itemElement = serverMessage.getDocument().createElement("item");
            itemElement.setAttribute("eid", elementId);
            Object property = textComponent.getProperty("cursorPosition");
            itemElement.setAttribute("cursorPosition", property != null ? property.toString() : "0");
            itemizedUpdateElement.appendChild(itemElement);
        }
    }

    private class TextUpdate
    implements PartialUpdateParticipant {
        private TextUpdate() {
        }

        public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
            return true;
        }

        public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
            TextComponent textComponent = (TextComponent)update.getParent();
            String elementId = ContainerInstance.getElementId((Component)textComponent);
            ServerMessage serverMessage = rc.getServerMessage();
            Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "EchoTextComponent.MessageProcessor", "set-text", new String[0], new String[0]);
            Element itemElement = serverMessage.getDocument().createElement("item");
            itemElement.setAttribute("eid", elementId);
            itemElement.setAttribute("text", textComponent.getText());
            itemizedUpdateElement.appendChild(itemElement);
        }
    }

    private static class DummyPeer
    extends nextapp.echo2.webcontainer.syncpeer.TextComponentPeer {
        private DummyPeer() {
        }

        public void renderHtml(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component component) {
        }
    }
}

