/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.tabpane;

import echopointng.tabbedpane.DefaultTabModel;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import org.openvpms.web.echo.button.ShortcutButton;
import org.openvpms.web.echo.button.ShortcutButtons;
import org.openvpms.web.echo.button.ShortcutHelper;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;

public class TabPaneModel
extends DefaultTabModel
implements KeyStrokeHandler {
    private final ShortcutButtons buttons;

    public TabPaneModel() {
        this(null);
    }

    public TabPaneModel(Component container) {
        this.buttons = container != null ? new ShortcutButtons(container) : null;
    }

    @Override
    public void reregisterKeyStrokeListeners() {
        if (this.buttons != null) {
            this.buttons.reregisterKeyStrokeListeners();
        }
    }

    protected Component createTabComponent(String tabTitle, ImageReference tabIcon) {
        ShortcutButton result = new ShortcutButton();
        result.setActionCommand(ShortcutHelper.getShortcut(tabTitle));
        result.setText(tabTitle);
        result.setIcon(tabIcon);
        ComponentFactory.setDefaultStyle((Component)result);
        result.setFocusTraversalParticipant(false);
        if (this.buttons != null) {
            this.buttons.add(result);
        }
        return result;
    }
}

