/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.table;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Date;
import java.util.function.Function;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public class CellFormat {
    public static Function<Object, Object> id() {
        return new NumberFunction(NumberFormatter.getFormat((String)"id.format"));
    }

    public static Function<Object, Object> currency() {
        return new NumberFunction(NumberFormatter.getCurrencyFormat());
    }

    public static Function<Object, Object> integer() {
        return CellFormat.number(NumberFormatter.getFormat((String)"integer.format.view"));
    }

    public static Function<Object, Object> decimal() {
        return CellFormat.number(NumberFormatter.getFormat((String)"decimal.format.view"));
    }

    public static Function<Object, Object> number() {
        return new DecimalIntegerFunction();
    }

    public static Function<Object, Object> number(NumberFormat format) {
        return new NumberFunction(format);
    }

    public static Function<Object, Object> percent() {
        return new PercentFunction();
    }

    public static Function<Object, Object> date() {
        return new DateFunction(DateFormatter.getDateFormat((boolean)false), false, false);
    }

    public static Function<Object, Object> dateTime() {
        return CellFormat.dateTime(false);
    }

    public static Function<Object, Object> dateTime(boolean excludeDateIfToday) {
        return new DateFunction(DateFormatter.getDateTimeFormat((boolean)false), true, excludeDateIfToday);
    }

    public static Function<Object, Object> format(Format format) {
        return new FormatFunction(format);
    }

    public static Function<Object, Object> value() {
        return CellFormat.text(false, false);
    }

    public static Function<Object, Object> text() {
        return CellFormat.text(true, true);
    }

    public static Function<Object, Object> text(boolean multiline, boolean wrap) {
        return new TextRenderer(multiline, wrap);
    }

    private static class TextRenderer
    implements Function<Object, Object> {
        private final boolean multiline;
        private final boolean wrap;

        public TextRenderer(boolean multiline, boolean wrap) {
            this.multiline = multiline;
            this.wrap = wrap;
        }

        @Override
        public Object apply(Object object) {
            Object result = null;
            if (object instanceof Component) {
                result = object;
            } else if (object != null) {
                Label label = LabelFactory.create(this.multiline, this.wrap);
                label.setText(object.toString());
                result = label;
            }
            return result;
        }
    }

    private static class DateFunction
    extends FormatFunction {
        private final DateFormat timeFormat;

        public DateFunction(DateFormat format, boolean dateTime, boolean excludeDateIfToday) {
            super(format);
            this.timeFormat = dateTime && excludeDateIfToday ? DateFormatter.getTimeFormat((boolean)false) : null;
        }

        @Override
        public Object apply(Object object) {
            Object result;
            if (object instanceof Date) {
                Date date = (Date)object;
                result = this.timeFormat != null && DateRules.isToday((Date)date) ? this.format(object, this.timeFormat) : this.format(date);
            } else {
                result = object instanceof Component ? object : this.toString(object);
            }
            return result;
        }
    }

    private static class PercentFunction
    extends DecimalIntegerFunction {
        private PercentFunction() {
        }

        @Override
        protected String format(Object object, Format format) {
            String result = super.format(object, format);
            return result != null ? result + "%" : null;
        }
    }

    private static class DecimalIntegerFunction
    extends NumberFunction {
        private final NumberFormat integer;

        public DecimalIntegerFunction() {
            this(NumberFormatter.getFormat((String)"decimal.format.view"), NumberFormatter.getFormat((String)"integer.format.view"));
        }

        public DecimalIntegerFunction(NumberFormat decimal, NumberFormat integer) {
            super(decimal);
            this.integer = integer;
        }

        @Override
        public Object apply(Object object) {
            Object result = object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof BigInteger ? TableHelper.rightAlign(this.format(object, this.integer)) : super.apply(object);
            return result;
        }
    }

    private static class NumberFunction
    extends FormatFunction {
        public NumberFunction(NumberFormat format) {
            super(format);
        }

        @Override
        public Object apply(Object object) {
            Object result = object instanceof Number ? TableHelper.rightAlign(this.format(object)) : (object instanceof Component ? object : this.toString(object));
            return result;
        }
    }

    private static class FormatFunction
    implements Function<Object, Object> {
        private final Format format;

        public FormatFunction(Format format) {
            this.format = format;
        }

        @Override
        public Object apply(Object object) {
            return object instanceof Component ? object : this.format(object);
        }

        protected String format(Object object) {
            return this.format(object, this.format);
        }

        protected String format(Object object, Format format) {
            String result = null;
            if (object != null) {
                try {
                    result = format.format(object);
                }
                catch (IllegalArgumentException exception) {
                    result = object.toString();
                }
            }
            return result;
        }

        protected String toString(Object object) {
            return object != null ? object.toString() : null;
        }
    }
}

