/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nextapp.echo2.app.MutableStyleSheet;
import nextapp.echo2.app.StyleSheet;
import org.openvpms.web.echo.style.AbstractStyleSheetCache;
import org.openvpms.web.echo.style.ResourceStyleSheetProperties;
import org.openvpms.web.echo.style.StyleSheetException;
import org.openvpms.web.echo.style.StyleSheetProperties;
import org.openvpms.web.echo.style.StyleSheetResources;
import org.openvpms.web.echo.style.StyleSheetTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSheetCache
extends AbstractStyleSheetCache {
    private final Pattern resolutionPattern = Pattern.compile("(\\d+)x(\\d+)");
    private final StyleSheetProperties properties;
    private final StyleSheetTemplate defaultTemplate;
    private final StyleSheetTemplate overrideTemplate;
    private static final Logger log = LoggerFactory.getLogger(StyleSheetCache.class);

    public StyleSheetCache(String defaultBaseName) throws IOException {
        this(new ResourceStyleSheetProperties(defaultBaseName, null));
    }

    public StyleSheetCache(StyleSheetProperties properties) throws IOException {
        this.defaultTemplate = this.getTemplate(properties.getDefaultName(), true);
        this.overrideTemplate = this.getTemplate(properties.getOverrideName(), false);
        this.properties = properties;
        this.setDefaultProperties(properties.getProperties());
        this.addResolutions(properties.getDefaultName(), properties.getOverrideName());
    }

    @Override
    public StyleSheet getStyleSheet(Map<String, String> properties) {
        MutableStyleSheet result = this.defaultTemplate.getStyleSheet(properties);
        if (this.overrideTemplate != null) {
            MutableStyleSheet override = this.overrideTemplate.getStyleSheet(properties);
            result.addStyleSheet(override);
        }
        return result;
    }

    public void reset() {
        this.clearCache();
        this.setDefaultProperties(this.properties.getProperties());
    }

    private StyleSheetTemplate getTemplate(String baseName, boolean required) throws IOException {
        StyleSheetTemplate result = null;
        String name = baseName + ".stylesheet";
        InputStream resource = StyleSheetResources.getResource(name, required);
        if (resource != null) {
            if (log.isInfoEnabled()) {
                log.info("Loading stylesheet " + name);
            }
            result = new StyleSheetTemplate(resource);
        }
        return result;
    }

    private void addResolutions(String defaultBaseName, String overrideBaseName) throws IOException {
        this.addResolutions(defaultBaseName);
        this.addResolutions(overrideBaseName);
    }

    private void addResolutions(String baseName) throws IOException {
        Map<String, String> resolutions = StyleSheetResources.getProperties(baseName + "-resolutions.properties", false);
        if (resolutions != null) {
            for (Map.Entry<String, String> entry : resolutions.entrySet()) {
                if (!entry.getKey().startsWith("resolution")) continue;
                this.addResolution(entry.getValue(), baseName);
            }
        }
    }

    private void addResolution(String resolution, String baseName) throws IOException {
        Dimension size;
        Map<String, String> properties;
        Matcher matcher = this.resolutionPattern.matcher(resolution);
        if (matcher.matches()) {
            int width = Integer.parseInt(matcher.group(1));
            int height = Integer.parseInt(matcher.group(2));
            String name = baseName + "-" + resolution + ".properties";
            properties = StyleSheetResources.getProperties(name, true);
            size = new Dimension(width, height);
            if (log.isInfoEnabled()) {
                if (this.getResolution(size) != null) {
                    log.info("Replacing resolution " + width + "x" + height + " with " + name);
                } else {
                    log.info("Adding resolution " + width + "x" + height + " from " + name);
                }
            }
        } else {
            throw new StyleSheetException(StyleSheetException.ErrorCode.InvalidResolution, resolution);
        }
        this.addResolution(size, properties);
    }
}

