/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.echo.servlet.SessionMonitor;
import org.springframework.beans.factory.DisposableBean;

public class SessionMonitorConfigurer
implements DisposableBean {
    private final IArchetypeService service;
    private final SessionMonitor monitor;
    private final IArchetypeServiceListener listener;

    public SessionMonitorConfigurer(SessionMonitor monitor, IArchetypeService service, PracticeRules rules) {
        this.monitor = monitor;
        this.service = service;
        Party practice = rules.getPractice();
        if (practice != null) {
            this.configure((IMObject)practice);
        }
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                SessionMonitorConfigurer.this.configure(object);
            }
        };
        service.addListener("party.organisationPractice", this.listener);
    }

    public void destroy() throws Exception {
        this.service.removeListener("party.organisationPractice", this.listener);
    }

    private void configure(IMObject practice) {
        IMObjectBean bean = this.service.getBean(practice);
        int autoLock = bean.getInt("autoLockScreen", 5);
        int autoLogout = bean.getInt("autoLogout", 30);
        this.monitor.setAutoLock(autoLock);
        this.monitor.setAutoLogout(autoLogout);
    }
}

