/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.Command;
import nextapp.echo2.webcontainer.command.BrowserOpenWindowCommand;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.echo.servlet.ServletHelper;
import org.openvpms.web.echo.util.LinkClicker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DownloadServlet
extends HttpServlet {
    private DocumentHandlers handlers;
    private static final Set<Reference> tempDocs = Collections.synchronizedSet(new HashSet());
    private static final Logger log = LoggerFactory.getLogger(DownloadServlet.class);

    public void init() throws ServletException {
        super.init();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        this.handlers = (DocumentHandlers)context.getBean(DocumentHandlers.class);
    }

    public static void startDownload(Document document) {
        ApplicationInstance app = ApplicationInstance.getActive();
        DownloadServlet.startDownload(document, app);
    }

    public static void startDownload(Document document, ApplicationInstance app) {
        boolean isNew = document.isNew();
        if (isNew) {
            IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
            service.save((IMObject)document);
            tempDocs.add(document.getObjectReference());
        }
        String uri = DownloadServlet.getDocumentURI(document.getObjectReference());
        LinkClicker command = Boolean.getBoolean("openvpms.download.window") ? new BrowserOpenWindowCommand(uri, null, "width=800,height=600,menubar=yes,toolbar=yes,location=yes,resizable=yes,scrollbars=yes") : new LinkClicker(uri);
        app.enqueueCommand((Command)command);
    }

    public static String getDocumentURI(Reference reference) {
        return ServletHelper.getRedirectURI("document") + "?archetype=" + reference.getArchetype() + "&id=" + reference.getId();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        String archetype = request.getParameter("archetype");
        long id = NumberUtils.toLong((String)request.getParameter("id"), (long)0L);
        if (StringUtils.isEmpty((CharSequence)archetype) || id <= 0L) {
            response.sendError(400);
        } else {
            IMObject object = service.get(archetype, id);
            if (object == null) {
                response.sendError(404);
            } else if (!(object instanceof Document)) {
                response.sendError(400);
            } else {
                this.serveDocument((Document)object, response, service);
            }
        }
    }

    private void serveDocument(Document doc, HttpServletResponse response, IArchetypeService service) throws IOException {
        try {
            DocumentHandler handler = this.handlers.get(doc.getName(), doc.getArchetype(), doc.getMimeType());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + doc.getName() + "\"");
            response.setContentType(doc.getMimeType());
            response.setContentLength(doc.getSize());
            try (InputStream stream = handler.getContent(doc);){
                IOUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream());
            }
            if (tempDocs.remove(doc.getObjectReference())) {
                service.remove((IMObject)doc);
            }
        }
        catch (OpenVPMSException exception) {
            log.error("Failed to serve document: name=" + doc.getName() + ", archetype=" + doc.getArchetype() + ", mimeType=" + doc.getMimeType(), (Throwable)exception);
            response.sendError(500);
        }
    }
}

