/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.service;

import java.io.IOException;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webrender.BaseHtmlDocument;
import nextapp.echo2.webrender.Connection;
import nextapp.echo2.webrender.ContentType;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;

public class WindowService
implements Service {
    public static final WindowService INSTANCE = new WindowService();
    public static final String ROOT_ID = "c_root";
    public static final Service CLIENT_ENGINE = JavaScriptService.forResource((String)"Echo.ClientEngine", (String)"/org/openvpms/web/echo/js/ClientEngine.js");

    private WindowService() {
    }

    public String getId() {
        return "Echo.Default";
    }

    public int getVersion() {
        return -1;
    }

    public void service(Connection conn) throws IOException {
        ContainerInstance ci = (ContainerInstance)conn.getUserInstance();
        conn.setContentType(ContentType.TEXT_HTML);
        boolean debug = !"false".equals(conn.getServlet().getInitParameter("echo2.debug"));
        BaseHtmlDocument baseDoc = new BaseHtmlDocument(ROOT_ID);
        baseDoc.setGenarator("NextApp Echo v2.1.1");
        baseDoc.addJavaScriptInclude(ci.getServiceUri(CLIENT_ENGINE));
        Element appleMeta = baseDoc.getDocument().createElement("meta");
        appleMeta.setAttribute("name", "apple-mobile-web-app-capable");
        appleMeta.setAttribute("content", "yes");
        baseDoc.getHeadElement().appendChild(appleMeta);
        Element viewport = baseDoc.getDocument().createElement("meta");
        viewport.setAttribute("name", "viewport");
        viewport.setAttribute("content", "initial-scale = 1.0");
        baseDoc.getHeadElement().appendChild(viewport);
        baseDoc.getBodyElement().setAttribute("onload", "EchoClientEngine.init('" + ci.getServletUri() + "', " + debug + ");");
        Element bodyElement = baseDoc.getBodyElement();
        CssStyle cssStyle = new CssStyle();
        cssStyle.setAttribute("position", "absolute");
        cssStyle.setAttribute("font-family", "verdana, arial, helvetica, sans-serif");
        cssStyle.setAttribute("font-size", "10pt");
        cssStyle.setAttribute("height", "100%");
        cssStyle.setAttribute("width", "100%");
        cssStyle.setAttribute("padding", "0px");
        cssStyle.setAttribute("margin", "0px");
        cssStyle.setAttribute("overflow", "hidden");
        bodyElement.setAttribute("style", cssStyle.renderInline());
        baseDoc.render(conn.getWriter());
    }
}

