/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.frame;

import echopointng.EPNG;
import echopointng.able.BackgroundImageable;
import echopointng.ui.resource.Resources;
import echopointng.ui.syncpeer.AbstractEchoPointContainerPeer;
import echopointng.ui.util.CssStyleEx;
import echopointng.ui.util.Render;
import echopointng.ui.util.RenderingContext;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Style;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ActionProcessor;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.PartialUpdateParticipant;
import nextapp.echo2.webcontainer.PropertyUpdateProcessor;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MonitoredFramePeer
extends AbstractEchoPointContainerPeer
implements PropertyUpdateProcessor,
ActionProcessor {
    private static final Service FRAME_SERVICE = JavaScriptService.forResource((String)"MonitoredFrame", (String)"/org/openvpms/web/echo/js/MonitoredFrame.js");

    public MonitoredFramePeer() {
        this.partialUpdateManager.add("horizontalScroll", new PartialUpdateParticipant(){

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                MonitoredFramePeer.this.renderScrollDirective(rc, update.getParent(), true);
            }

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
        this.partialUpdateManager.add("verticalScroll", new PartialUpdateParticipant(){

            public void renderProperty(RenderContext rc, ServerComponentUpdate update) {
                MonitoredFramePeer.this.renderScrollDirective(rc, update.getParent(), false);
            }

            public boolean canRenderProperty(RenderContext rc, ServerComponentUpdate update) {
                return true;
            }
        });
    }

    public void processAction(ContainerInstance containerInstance, Component component, Element element) {
        String value = element.getAttribute("value");
        containerInstance.getUpdateManager().getClientUpdateManager().setComponentAction(component, "message", (Object)value);
    }

    public void processPropertyUpdate(ContainerInstance ci, Component component, Element propertyElement) {
        if ("horizontalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent((String)propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "horizontalScroll", (Object)newValue);
        } else if ("verticalScroll".equals(propertyElement.getAttribute("name"))) {
            Extent newValue = ExtentRender.toExtent((String)propertyElement.getAttribute("value"));
            ci.getUpdateManager().getClientUpdateManager().setComponentProperty(component, "verticalScroll", (Object)newValue);
        }
    }

    public void renderHtml(RenderingContext rc, Node parentNode, Component component) {
        rc.addLibrary(FRAME_SERVICE);
        rc.addLibrary(Resources.EP_SCRIPT_SERVICE);
        rc.addLibrary(Resources.EP_STRETCH_SERVICE);
        Style fallbackStyle = EPNG.getFallBackStyle((Component)component);
        CssStyleEx style = new CssStyleEx(component, fallbackStyle);
        Render.asBackgroundImageable((RenderContext)rc, (CssStyle)style, (BackgroundImageable)((BackgroundImageable)component), (Style)fallbackStyle);
        style.setAttribute("position", "absolute");
        style.setAttribute("width", "100%");
        style.setAttribute("height", "100%");
        style.setAttribute("overflow", "auto");
        Render.layoutFix((RenderContext)rc, (CssStyle)style);
        Element paneE = rc.createE("div");
        parentNode.appendChild(paneE);
        paneE.setAttribute("id", rc.getElementId());
        paneE.setAttribute("style", style.renderInline());
        rc.addStandardWebSupport(paneE);
        style = new CssStyleEx();
        style.setAttribute("position", "relative");
        style.setAttribute("width", "100%");
        style.setAttribute("height", "100%");
        style.setAttribute("border-style", "none");
        Element iframeE = rc.createE("iframe");
        iframeE.setAttribute("id", rc.getElementId() + "_frame");
        iframeE.setAttribute("style", style.renderInline());
        iframeE.setAttribute("src", (String)rc.getRP("uri", fallbackStyle));
        paneE.appendChild(iframeE);
        this.renderInitDirective(rc, component);
    }

    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        super.renderDispose(rc, update, component);
        rc.getServerMessage().addLibrary(Resources.EP_SCRIPT_SERVICE.getId());
        rc.getServerMessage().addLibrary(Resources.EP_STRETCH_SERVICE.getId());
        rc.getServerMessage().addLibrary(FRAME_SERVICE.getId());
        this.renderDisposeDirective(rc, component);
    }

    protected Element renderReplaceableChild(RenderContext rc, ServerComponentUpdate update, Node parentNode, Component child) {
        throw new IllegalStateException("Not supported");
    }

    private void renderScrollDirective(RenderContext rc, Component component, boolean horizontal) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element scrollElement = serverMessage.appendPartDirective("postupdate", "MonitoredFrame.MessageProcessor", horizontal ? "scroll-horizontal" : "scroll-vertical");
        Extent position = (Extent)component.getRenderProperty(horizontal ? "horizontalScroll" : "verticalScroll", (Object)new Extent(0));
        scrollElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        scrollElement.setAttribute("position", ExtentRender.renderCssAttributeValue((Extent)position));
    }

    private void renderDisposeDirective(RenderContext rc, Component component) {
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "MonitoredFrame.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", ContainerInstance.getElementId((Component)component));
        itemizedUpdateElement.appendChild(itemElement);
    }

    private void renderInitDirective(RenderingContext rc, Component component) {
        Extent verticalScroll;
        String elementId = ContainerInstance.getElementId((Component)component);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "MonitoredFrame.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        Extent horizontalScroll = (Extent)component.getRenderProperty("horizontalScroll");
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributeValue((Extent)horizontalScroll));
        }
        if ((verticalScroll = (Extent)component.getRenderProperty("verticalScroll")) != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributeValue((Extent)verticalScroll));
        }
        if (rc.getRP("heightStretched", false)) {
            itemElement.setAttribute("heightStretched", String.valueOf(true));
            itemElement.setAttribute("minimumStretchedHeight", MonitoredFramePeer.getExtentPixels(rc.getRP("minimumStretchedHeight", null)));
            itemElement.setAttribute("maximumStretchedHeight", MonitoredFramePeer.getExtentPixels(rc.getRP("maximumStretchedHeight", null)));
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    private static String getExtentPixels(Object extent) {
        if (extent instanceof Extent) {
            return String.valueOf(((Extent)extent).getValue());
        }
        return null;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(FRAME_SERVICE);
    }
}

