/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.factory;

import echopointng.LabelEx;
import echopointng.xhtml.XhtmlFragment;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.CellLayoutData;
import org.apache.commons.text.StringEscapeUtils;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.text.TextHelper;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public final class LabelFactory
extends ComponentFactory {
    private static final String TYPE = "label";

    public static Label create() {
        return LabelFactory.create(false);
    }

    public static Label text(String text) {
        Label label = LabelFactory.create(true);
        label.setText(text);
        return label;
    }

    public static Label text(String text, String style) {
        return LabelFactory.text(text, style, false);
    }

    public static Label text(String text, String style, boolean wrap) {
        Label label = LabelFactory.text(text, wrap);
        label.setStyleName(style);
        label.setLineWrap(wrap);
        return label;
    }

    public static Label text(String text, boolean wrap) {
        Label label = LabelFactory.text(text);
        label.setLineWrap(wrap);
        return label;
    }

    public static Label html(String html) {
        return LabelFactory.html(html, false);
    }

    public static Label html(String html, boolean wrap) {
        html = "<span xmlns='http://www.w3.org/1999/xhtml'>" + LabelFactory.replaceControlChars(html) + "</span>";
        LabelEx label = new LabelEx(new XhtmlFragment(html));
        label.setLineWrap(wrap);
        return label;
    }

    public static Label create(boolean multiline) {
        return LabelFactory.create(multiline, false);
    }

    public static Label create(boolean multiline, boolean wrap) {
        Object result;
        if (multiline) {
            ProtectedLabelEx label = new ProtectedLabelEx();
            label.setIntepretNewlines(true);
            result = label;
        } else {
            result = new Label(){

                public void setText(String newValue) {
                    newValue = LabelFactory.replaceControlChars(newValue);
                    super.setText(newValue);
                }
            };
        }
        result.setLineWrap(wrap);
        LabelFactory.setDefaultStyle((Component)result);
        return result;
    }

    public static Label create(ImageReference image) {
        Label label = LabelFactory.create();
        label.setIcon(image);
        return label;
    }

    public static Label create(String key) {
        return LabelFactory.create(key, false);
    }

    public static Label create(String key, boolean multiline) {
        return LabelFactory.create(key, multiline, false);
    }

    public static Label create(String key, boolean multiline, boolean wrap) {
        Label label = LabelFactory.create(multiline, wrap);
        if (key != null) {
            label.setText(LabelFactory.getString(TYPE, key, false));
        }
        return label;
    }

    public static Label create(String key, String style) {
        Label label = LabelFactory.create(key);
        LabelFactory.setStyle((Component)label, style);
        return label;
    }

    public static Label create(Number value, CellLayoutData layout) {
        Label label = LabelFactory.create();
        label.setText(NumberFormatter.format((Number)value));
        return LabelFactory.rightAlign(label, layout);
    }

    public static Label create(long value, CellLayoutData layout) {
        Label label = LabelFactory.create();
        label.setText(NumberFormatter.format((Number)value));
        return LabelFactory.rightAlign(label, layout);
    }

    public static Label preformatted(String text) {
        return LabelFactory.preformatted(text, false);
    }

    public static Label preformatted(String text, boolean wrap) {
        PreformattedLabelEx label = new PreformattedLabelEx(wrap);
        label.setText(text);
        LabelFactory.setDefaultStyle((Component)label);
        return label;
    }

    private static Label rightAlign(Label label, CellLayoutData layout) {
        layout.setAlignment(new Alignment(5, 0));
        label.setLayoutData((LayoutData)layout);
        return label;
    }

    private static String replaceControlChars(String text) {
        if (TextHelper.hasControlChars(text)) {
            text = TextHelper.replaceControlChars(text, " ");
        }
        return text;
    }

    private static class PreformattedLabelEx
    extends LabelEx {
        private final boolean wrap;

        public PreformattedLabelEx(boolean wrap) {
            this.wrap = wrap;
        }

        public void setText(String newValue) {
            if (newValue != null) {
                newValue = LabelFactory.replaceControlChars(newValue);
                StringBuilder builder = new StringBuilder();
                builder.append("<div xmlns='http://www.w3.org/1999/xhtml' ");
                builder.append(this.wrap ? "style='white-space:pre-wrap'>" : "style='white-space:pre'>");
                builder.append(StringEscapeUtils.escapeXml11((String)newValue));
                builder.append("</div>");
                this.setText(new XhtmlFragment(builder.toString()));
            } else {
                super.setText(newValue);
            }
        }
    }

    private static class ProtectedLabelEx
    extends LabelEx {
        private ProtectedLabelEx() {
        }

        public void setText(String newValue) {
            super.setText(LabelFactory.replaceControlChars(newValue));
        }
    }
}

