/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.button.ButtonGroup;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.OptionDialogBuilder;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;

public class OptionDialog
extends MessageDialog {
    private final List<Option> options = new ArrayList<Option>();
    private boolean closeOnSelection = false;
    private final ActionListener listener;

    public OptionDialog(String title, String message, String[] options) {
        this(title, message, options, (HelpContext)null);
    }

    public OptionDialog(String title, String message, String[] options, String[] buttons) {
        this(title, message, options, buttons, null);
    }

    public OptionDialog(String title, String message, String[] options, HelpContext help) {
        this(title, message, options, OK_CANCEL, help);
    }

    public OptionDialog(String title, String message, String[] options, String[] buttons, HelpContext help) {
        super(title, message, buttons, help);
        this.listener = new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                OptionDialog.this.onSelected();
            }
        };
        ButtonGroup group = new ButtonGroup();
        for (String option : options) {
            this.addOption(group, option, null);
        }
    }

    public OptionDialog(OptionDialogBuilder builder) {
        super(builder);
        this.listener = new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                OptionDialog.this.onSelected();
            }
        };
        ButtonGroup group = new ButtonGroup();
        for (Map.Entry<String, Runnable> option : builder.getOptions().entrySet()) {
            this.addOption(group, option.getKey(), option.getValue());
        }
        if (builder.getSelected() != -1) {
            this.setSelected(builder.getSelected());
        }
        this.setCloseOnSelection(builder.isCloseOnSelection());
    }

    public void setSelected(int selected) {
        if (selected >= 0 && selected < this.options.size()) {
            this.options.get(selected).button.setSelected(true);
        } else {
            for (Option option : this.options) {
                option.button.setSelected(false);
            }
        }
    }

    public RadioButton getOption(int index) {
        return index >= 0 && index < this.options.size() ? this.options.get(index).button : null;
    }

    public int getSelected() {
        int selected = -1;
        for (int i = 0; i < this.options.size(); ++i) {
            if (!this.options.get(i).button.isSelected()) continue;
            selected = i;
            break;
        }
        return selected;
    }

    public void setCloseOnSelection(boolean close) {
        if (close != this.closeOnSelection) {
            this.closeOnSelection = close;
            for (Option option : this.options) {
                RadioButton button = option.button;
                if (close) {
                    button.addActionListener((nextapp.echo2.app.event.ActionListener)this.listener);
                    continue;
                }
                button.removeActionListener((nextapp.echo2.app.event.ActionListener)this.listener);
            }
        }
    }

    public static OptionDialogBuilder newDialog() {
        return new OptionDialogBuilder();
    }

    @Override
    protected void onOK() {
        int selected = this.getSelected();
        if (selected != -1) {
            super.onOK();
            Option option = this.options.get(selected);
            if (option.listener != null) {
                this.runProtected(option.listener);
            }
        }
    }

    @Override
    protected void doLayout() {
        Label message = LabelFactory.create(true, true);
        message.setText(this.getMessage());
        Column column = ColumnFactory.create("WideCellSpacing", new Component[]{message});
        for (Option option : this.options) {
            column.add((Component)option.button);
        }
        this.getLayout().add((Component)ColumnFactory.create("Inset.Large", new Component[]{column}));
    }

    private void addOption(ButtonGroup group, String text, Runnable listener) {
        RadioButton button = ButtonFactory.create(null, group);
        button.setText(text);
        group.addButton(button);
        this.options.add(new Option(button, listener));
    }

    private void onSelected() {
        if (this.closeOnSelection) {
            this.onOK();
        }
    }

    private static class Option {
        private final RadioButton button;
        private final Runnable listener;

        public Option(RadioButton button, Runnable listener) {
            this.button = button;
            this.listener = listener;
        }
    }
}

