/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.web.echo.dialog.MessageDialog;
import org.openvpms.web.echo.dialog.PopupWindow;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public abstract class MessageDialogBuilder<T extends MessageDialog, B extends MessageDialogBuilder<T, B>> {
    private final List<String> buttons = new ArrayList<String>();
    private final Map<String, Runnable> listeners = new HashMap<String, Runnable>();
    private final Map<String, Boolean> disableShortcuts = new HashMap<String, Boolean>();
    private String defaultButton;
    private String title;
    private String preamble;
    private String message;
    private boolean messageHTML;
    private String footer;
    private String style;
    private String size;
    private boolean sizeToContent;
    private Extent x;
    private Extent y;
    private HelpContext help;
    private Consumer<String> defaultListener;
    private WindowPaneListener listener;

    public B title(String title) {
        this.title = title;
        return this.getThis();
    }

    public B titleKey(String key, Object ... args) {
        return this.title(Messages.format((String)key, (Object[])args));
    }

    public String getTitle() {
        return this.title;
    }

    public B preamble(String preamble) {
        this.preamble = preamble;
        return this.getThis();
    }

    public B preambleKey(String key, Object ... args) {
        return this.preamble(Messages.format((String)key, (Object[])args));
    }

    public String getPreamble() {
        return this.preamble;
    }

    public B message(String message) {
        return this.message(message, false);
    }

    public B message(String message, boolean html) {
        this.message = message;
        this.messageHTML = html;
        return this.getThis();
    }

    public B messageKey(String key, Object ... args) {
        return this.message(Messages.format((String)key, (Object[])args));
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMessageHTML() {
        return this.messageHTML;
    }

    public B footer(String footer) {
        this.footer = footer;
        return this.getThis();
    }

    public B footerKey(String key, Object ... args) {
        return this.footer(Messages.format((String)key, (Object[])args));
    }

    public String getFooter() {
        return this.footer;
    }

    public B ok() {
        this.buttons("ok");
        return this.defaultButton("ok");
    }

    public B okCancel() {
        this.buttons(MessageDialog.OK_CANCEL);
        return this.defaultButton("cancel");
    }

    public B cancel() {
        this.buttons("cancel");
        return this.defaultButton("cancel");
    }

    public B yesNo() {
        this.buttons(MessageDialog.YES_NO);
        return this.defaultButton("no");
    }

    public B yesNoCancel() {
        this.buttons(MessageDialog.YES_NO_CANCEL);
        return this.defaultButton("cancel");
    }

    public B yes(Runnable listener) {
        return this.yes(false, listener);
    }

    public B yes(boolean disableShortcut, Runnable listener) {
        return this.button("yes", disableShortcut, listener);
    }

    public B no(Runnable listener) {
        return this.button("no", listener);
    }

    public B ok(Runnable listener) {
        return this.button("ok", listener);
    }

    public B ok(boolean disableShortcut, Runnable listener) {
        return this.button("ok", disableShortcut, listener);
    }

    public B cancel(Runnable listener) {
        return this.button("cancel", listener);
    }

    public B button(String button, Runnable listener) {
        return this.button(button, false, listener);
    }

    public B button(String button, boolean disableShortcut, Runnable listener) {
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
        }
        this.disableShortcuts.put(button, disableShortcut);
        this.listeners.put(button, listener);
        return this.getThis();
    }

    public B buttons(String ... buttons) {
        this.buttons.addAll(Arrays.asList(buttons));
        return this.getThis();
    }

    public List<String> getButtons() {
        return this.buttons;
    }

    public B defaultButton(String defaultButton) {
        this.defaultButton = defaultButton;
        return this.getThis();
    }

    public String getDefaultButton() {
        return this.defaultButton;
    }

    public B style(String style) {
        this.style = style;
        return this.getThis();
    }

    public String getStyle() {
        return this.style;
    }

    public B size(String size) {
        this.size = size;
        return this.getThis();
    }

    public String getSize() {
        return this.size;
    }

    public B sizeToContent() {
        this.sizeToContent = true;
        return this.getThis();
    }

    public boolean getSizeToContent() {
        return this.sizeToContent;
    }

    public B position(int x, int y) {
        return this.position(new Extent(x), new Extent(y));
    }

    public B position(Extent x, Extent y) {
        this.x = x;
        this.y = y;
        return this.getThis();
    }

    public Extent getX() {
        return this.x;
    }

    public Extent getY() {
        return this.y;
    }

    public B help(HelpContext help) {
        this.help = help;
        return this.getThis();
    }

    public HelpContext getHelp() {
        return this.help;
    }

    public B listener(WindowPaneListener listener) {
        this.listener = listener;
        return this.getThis();
    }

    public B listener(final Runnable listener) {
        this.listener = listener != null ? new org.openvpms.web.echo.event.WindowPaneListener(){

            @Override
            public void onClose(WindowPaneEvent event) {
                listener.run();
            }
        } : null;
        return this.getThis();
    }

    public WindowPaneListener getListener() {
        return this.listener;
    }

    public B defaultListener(Consumer<String> defaultListener) {
        this.defaultListener = defaultListener;
        return this.getThis();
    }

    public Consumer<String> getDefaultListener() {
        return this.defaultListener;
    }

    public Map<String, Runnable> getListeners() {
        return this.listeners;
    }

    public abstract T build();

    public T show() {
        T dialog = this.build();
        ((PopupWindow)((Object)dialog)).show();
        return dialog;
    }

    public T show(int time) {
        T dialog = this.build();
        ((MessageDialog)((Object)dialog)).show(time);
        return dialog;
    }

    public boolean disableShortcut(String button) {
        Boolean disable = this.disableShortcuts.get(button);
        return disable != null && disable != false;
    }

    protected abstract B getThis();
}

