/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.dialog;

import echopointng.xhtml.XhtmlFragment;
import java.util.Map;
import java.util.function.Consumer;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.event.WindowPaneEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.echo.dialog.MessageDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.event.WindowPaneListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.util.StyleSheetHelper;

public abstract class MessageDialog
extends ModalDialog {
    private final String preamble;
    private final String message;
    private final boolean messageHTML;
    private final String footer;
    private static final String STYLE = "MessageDialog";

    public MessageDialog(String title, String message, String[] buttons) {
        this(title, message, STYLE, buttons);
    }

    public MessageDialog(String title, String message, String[] buttons, HelpContext help) {
        this(title, message, STYLE, buttons, help);
    }

    public MessageDialog(String title, String message, String style, String[] buttons) {
        this(title, message, style, buttons, null);
    }

    public MessageDialog(String title, String message, String style, String[] buttons, HelpContext help) {
        super(title, style, buttons, help);
        this.message = message;
        this.messageHTML = false;
        this.preamble = null;
        this.footer = null;
    }

    protected MessageDialog(MessageDialogBuilder<?, ?> builder) {
        super(builder.getTitle(), builder.getStyle(), new String[0], builder.getHelp());
        if (builder.getButtons().isEmpty()) {
            builder.ok();
        }
        for (String button : builder.getButtons()) {
            this.addButton(button, builder.disableShortcut(button));
        }
        this.setDefaultButton(builder.getDefaultButton());
        this.preamble = builder.getPreamble();
        this.message = builder.getMessage();
        this.messageHTML = builder.isMessageHTML() && this.isValidHTML(this.message);
        this.footer = builder.getFooter();
        this.addWindowPaneListener(builder);
        String size = builder.getSize();
        if (size != null) {
            this.resize(size);
        } else if (builder.getSizeToContent()) {
            this.sizeToContent();
        }
        if (builder.getX() != null) {
            this.setPositionX(builder.getX());
        }
        if (builder.getY() != null) {
            this.setPositionY(builder.getY());
        }
    }

    protected void addWindowPaneListener(MessageDialogBuilder<?, ?> builder) {
        final Consumer<String> defaultListener = builder.getDefaultListener();
        final Map<String, Runnable> listeners = builder.getListeners();
        if (defaultListener != null || !listeners.isEmpty()) {
            this.addWindowPaneListener(new WindowPaneListener(){

                @Override
                public void onClose(WindowPaneEvent event) {
                    MessageDialog.this.onButton(listeners, defaultListener);
                }
            });
        } else if (builder.getListener() != null) {
            this.addWindowPaneListener(builder.getListener());
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void show(int time) {
        this.show();
        SpringApplicationInstance app = (SpringApplicationInstance)this.getApplicationInstance();
        app.getTaskQueues().schedule(time, this::userClose);
    }

    @Override
    protected void doLayout() {
        if (this.preamble == null && this.footer == null) {
            Label content;
            if (this.messageHTML) {
                content = LabelFactory.html(this.message, true);
            } else {
                content = LabelFactory.create(true, true);
                content.setText(this.message);
            }
            Row row = RowFactory.create("Inset.Large", new Component[]{content});
            this.getLayout().add((Component)row);
        } else {
            Row row;
            Label label;
            Insets large = StyleSheetHelper.getInsets(Column.class, "Inset.Large", "insets");
            Insets insets = StyleSheetHelper.getInsets(Column.class, "Inset", "insets");
            Grid grid = GridFactory.create(1);
            grid.setInsets(new Insets(large.getLeft(), new Extent(0), large.getRight(), new Extent(0)));
            grid.setWidth(Styles.FULL_WIDTH);
            grid.setColumnWidth(0, Styles.FULL_WIDTH);
            grid.setHeight(Styles.FULL_HEIGHT);
            if (this.preamble != null) {
                label = LabelFactory.text(this.preamble, true);
                row = RowFactory.create(new Component[]{label});
                row.setInsets(new Insets(new Extent(0), large.getTop(), new Extent(0), insets.getBottom()));
                grid.add((Component)row);
            }
            if (this.messageHTML) {
                grid.add((Component)LabelFactory.html(this.message, true));
            } else {
                TextArea text = this.createTextArea(this.message);
                grid.add((Component)text);
                if (this.footer != null) {
                    int lines = 0;
                    if (!StringUtils.isEmpty((CharSequence)this.message)) {
                        lines = StringUtils.countMatches((CharSequence)this.message, (CharSequence)"\n");
                        lines = Math.max(this.message.length() / 60, lines);
                    }
                    if (lines < 3) {
                        lines = 3;
                    } else if (lines > 10) {
                        lines = 10;
                    }
                    text.setHeight(new Extent(lines, 64));
                } else {
                    text.setHeight(new Extent(90, 2));
                    grid.setRowHeight(grid.getComponentCount() - 1, Styles.FULL_HEIGHT);
                }
                text.setWidth(Styles.FULL_WIDTH);
            }
            if (this.footer != null) {
                label = LabelFactory.text(this.footer, true);
                row = RowFactory.create(new Component[]{label});
                row.setInsets(new Insets(new Extent(0), large.getTop(), new Extent(0), large.getBottom()));
                grid.add((Component)row);
            }
            this.getLayout().add((Component)grid);
        }
    }

    protected void sizeToContent() {
        int fontSize = StyleSheetHelper.getProperty("font.size", 10);
        int lines = this.getLines(this.message);
        if (this.footer != null) {
            lines += this.getLines(this.footer);
            ++lines;
        }
        this.setContentHeight((lines += 2) * fontSize);
    }

    protected TextArea createTextArea(String message) {
        TextArea text = TextComponentFactory.createTextArea();
        text.setText(message);
        text.setEnabled(false);
        return text;
    }

    private int getLines(String text) {
        int lines = StringUtils.countMatches((CharSequence)text, (CharSequence)"\n");
        if (lines == 0) {
            lines = text.length() / 60;
        }
        return lines;
    }

    protected void runProtected(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            ErrorHandler.getInstance().error(exception);
        }
    }

    private void onButton(Map<String, Runnable> listeners, Consumer<String> defaultListener) {
        Runnable runnable;
        boolean handled = false;
        String action = this.getAction();
        if (action != null && (runnable = listeners.get(action)) != null) {
            handled = true;
            this.runProtected(runnable);
        }
        if (!handled && defaultListener != null) {
            try {
                defaultListener.accept(action);
            }
            catch (Exception exception) {
                ErrorHandler.getInstance().error(exception);
            }
        }
    }

    private boolean isValidHTML(String message) {
        return message != null && XhtmlFragment.isValidXML((String)message) == null;
    }
}

