/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.button;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.RadioButton;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.keyboard.KeyStrokeHandler;

public class ButtonRow
extends Row
implements KeyStrokeHandler {
    public static final String STYLE = "ButtonRow";
    public static final String BUTTON_STYLE = "default";
    private final ButtonSet set;

    public ButtonRow() {
        this(STYLE, BUTTON_STYLE);
    }

    public ButtonRow(String rowStyle) {
        this(rowStyle, BUTTON_STYLE);
    }

    public ButtonRow(FocusGroup focus) {
        this(focus, STYLE, BUTTON_STYLE);
    }

    public ButtonRow(String rowStyle, String buttonStyle) {
        this(null, rowStyle, buttonStyle);
    }

    public ButtonRow(FocusGroup focus, String rowStyle, String buttonStyle) {
        this.setStyleName(rowStyle);
        this.set = new ButtonSet((Component)this, focus, buttonStyle);
    }

    public ButtonRow(Component shortcutContainer, FocusGroup focus) {
        this(shortcutContainer, focus, STYLE, BUTTON_STYLE);
    }

    public ButtonRow(Component shortcutContainer, FocusGroup focus, String rowStyle, String buttonStyle) {
        this.setStyleName(rowStyle);
        this.set = new ButtonSet((Component)this, shortcutContainer, focus, buttonStyle);
    }

    public ButtonSet getButtons() {
        return this.set;
    }

    public Button addButton() {
        return this.set.add();
    }

    public void addButton(Button button) {
        this.set.add(button);
    }

    public Button addButton(String key) {
        return this.set.add(key);
    }

    public Button addButton(String key, final Runnable listener) {
        return this.addButton(key, new ActionListener(){

            @Override
            public void onAction(ActionEvent event) {
                listener.run();
            }
        });
    }

    public Button addButton(String key, nextapp.echo2.app.event.ActionListener listener) {
        return this.addButton(key, false, listener);
    }

    public Button addButton(String key, boolean disableShortcut, Runnable listener) {
        return this.set.add(key, disableShortcut, listener);
    }

    public Button addButton(String key, boolean disableShortcut, nextapp.echo2.app.event.ActionListener listener) {
        return this.set.add(key, disableShortcut, listener);
    }

    public void addButton(RadioButton button) {
        this.set.add(button);
    }

    public void removeButton(AbstractButton button) {
        this.set.remove(button);
    }

    public void remove(Component component) {
        super.remove(component);
        if (component instanceof Button) {
            this.removeButton((AbstractButton)((Button)component));
        }
    }

    @Override
    public void reregisterKeyStrokeListeners() {
        this.set.reregisterKeyStrokeListeners();
    }
}

