/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2020 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.echo.style;

import nextapp.echo2.app.Extent;

/**
 * Stylesheet helper.
 *
 * @author Tim Anderson
 */
public final class Styles {

    /**
     * Default style name.
     */
    public static final String DEFAULT = "default";

    /**
     * Edit style name.
     */
    public static final String EDIT = "edit";

    /**
     * Error style name.
     */
    public static final String ERROR = "error";

    /**
     * Bold style name.
     */
    public static final String BOLD = "bold";

    /**
     * Italic style name.
     */
    public static final String ITALIC = "italic";

    /**
     * Inset style name.
     */
    public static final String INSET = "Inset";

    /**
     * Horizontal inset style name
     */
    public static final String INSET_X = "InsetX";

    /**
     * Vertical inset style name.
     */
    public static final String INSET_Y = "InsetY";

    /**
     * Large inset style name.
     */
    public static final String LARGE_INSET = "Inset.Large";

    /**
     * Large horizontal inset style name.
     */
    public static final String LARGE_INSET_X = "InsetX.Large";

    /**
     * Small inset style name.
     */
    public static final String SMALL_INSET = "Inset.Small";

    /**
     * Cell spacing style name.
     */
    public static final String CELL_SPACING = "CellSpacing";

    /**
     * Wide cell spacing style name.
     */
    public static final String WIDE_CELL_SPACING = "WideCellSpacing";

    /**
     * Inset cell spacing style name.
     */
    public static final String INSET_CELL_SPACING = "InsetCellSpacing";

    /**
     * Selected style name.
     */
    public static final String SELECTED = "selected";

    /**
     * Heading 1.
     */
    public static final String H1 = "h1";

    /**
     * Heading 2.
     */
    public static final String H2 = "h2";

    /**
     * Heading 3.
     */
    public static final String H3 = "h3";

    /**
     * Heading 4.
     */
    public static final String H4 = "h4";

    /**
     * Heading 5.
     */
    public static final String H5 = "h5";

    /**
     * An extent to fill the available width.
     */
    public static final Extent FULL_WIDTH = new Extent(100, Extent.PERCENT);

    /**
     * An extent to fill the available height.
     */
    public static final Extent FULL_HEIGHT = FULL_WIDTH;

    /**
     * Monospace font style for text and label components.
     */
    public static final String MONOSPACE = "monospace";
}
