/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2020 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.web.echo.dialog;

/**
 * Builder for {@link InformationDialog}s.
 *
 * @author Tim Anderson
 */
public class InformationDialogBuilder extends MessageDialogBuilder<InformationDialog, InformationDialogBuilder> {

    /**
     * Constructs an {@link InformationDialogBuilder}.
     */
    InformationDialogBuilder() {
        style(InformationDialog.STYLE);
    }

    /**
     * Builds the dialog.
     *
     * @return the dialog
     */
    @Override
    public InformationDialog build() {
        return new InformationDialog(this);
    }

    /**
     * Returns this.
     *
     * @return this
     */
    @Override
    protected InformationDialogBuilder getThis() {
        return this;
    }
}
