/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextapp.echo2.app.ApplicationInstance;
import nextapp.echo2.app.WindowPane;
import org.openvpms.web.echo.util.PeriodicTask;
import org.openvpms.web.echo.util.RestartableTask;
import org.openvpms.web.echo.util.RestartableTaskQueue;
import org.openvpms.web.echo.util.TaskQueue;

public class TaskQueues {
    private final Set<RestartableTask> tasks = Collections.synchronizedSet(new HashSet());
    private final Map<RestartableTask, List<WeakReference<WindowPane>>> suspendedTasks = Collections.synchronizedMap(new HashMap());
    private ApplicationInstance app;

    public TaskQueues(ApplicationInstance app) {
        this.app = app;
    }

    public void schedule(int delay, Runnable task) {
        PeriodicTask periodicTask = this.newTask(delay, delay, true, task);
        periodicTask.start();
    }

    public PeriodicTask newTask(int interval, Runnable task) {
        return this.newTask(0, interval, task);
    }

    public PeriodicTask newTask(int initialDelay, int interval, Runnable task) {
        return this.newTask(initialDelay, interval, false, task);
    }

    public TaskQueue newQueue(QueueMode queueMode) {
        return this.newQueue(0, queueMode);
    }

    public TaskQueue newQueue(int interval, QueueMode queueMode) {
        if (this.app == null) {
            throw new IllegalStateException("TaskQueues has been disposed");
        }
        RestartableTaskQueue queue = new RestartableTaskQueue(this.app, interval, true, queueMode){

            @Override
            public void dispose() {
                super.dispose();
                TaskQueues.this.tasks.remove(this);
            }
        };
        this.tasks.add(queue);
        return queue;
    }

    public boolean suspend(WindowPane window) {
        boolean suspended = false;
        for (RestartableTask task : this.tasks.toArray(new RestartableTask[0])) {
            if (!task.isRunning()) continue;
            task.stop();
            this.suspendedTasks.computeIfAbsent(task, k -> new ArrayList());
        }
        for (List list : this.suspendedTasks.values()) {
            list.removeIf(reference -> reference.get() == null);
            list.add(new WeakReference<WindowPane>(window));
            suspended = true;
        }
        return suspended;
    }

    public void resume(WindowPane window) {
        for (Map.Entry<RestartableTask, List<WeakReference<WindowPane>>> entry : this.getSuspendedTasks()) {
            RestartableTask task = entry.getKey();
            List<WeakReference<WindowPane>> windows = entry.getValue();
            if (windows == null) continue;
            windows.removeIf(reference -> {
                WindowPane other = (WindowPane)reference.get();
                return other == null || window == other;
            });
            if (!windows.isEmpty()) continue;
            this.suspendedTasks.remove(task);
            task.start();
        }
    }

    public void dispose() {
        for (RestartableTask task : this.tasks.toArray(new RestartableTask[0])) {
            task.dispose();
        }
        this.suspendedTasks.clear();
        this.app = null;
    }

    private Map.Entry<RestartableTask, List<WeakReference<WindowPane>>>[] getSuspendedTasks() {
        return this.suspendedTasks.entrySet().toArray(new Map.Entry[0]);
    }

    private PeriodicTask newTask(int initialDelay, int interval, boolean once, Runnable task) {
        if (this.app == null) {
            throw new IllegalStateException("TaskQueues has been disposed");
        }
        return new ManagedPeriodicTask(initialDelay, interval, once, task);
    }

    private class ManagedPeriodicTask
    extends PeriodicTask {
        public ManagedPeriodicTask(int initialDelay, int interval, boolean once, Runnable task) {
            super(TaskQueues.this.app, initialDelay, interval, once, task);
        }

        @Override
        public boolean start() {
            boolean started = super.start();
            if (started) {
                TaskQueues.this.tasks.add(this);
                TaskQueues.this.suspendedTasks.remove(this);
            }
            return started;
        }

        @Override
        public boolean stop() {
            boolean stopped = super.stop();
            if (stopped) {
                TaskQueues.this.tasks.remove(this);
                TaskQueues.this.suspendedTasks.remove(this);
            }
            return stopped;
        }
    }

    public static enum QueueMode {
        DISCARD,
        QUEUE_LAST,
        QUEUE_ALL;

    }
}

