/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import nextapp.echo2.app.ApplicationInstance;
import org.openvpms.web.echo.util.RestartableTask;
import org.openvpms.web.echo.util.RestartableTaskQueue;
import org.openvpms.web.echo.util.TaskQueues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicTask
implements RestartableTask {
    private final RestartableTaskQueue taskQueue;
    private final int initialDelay;
    private final boolean once;
    private Runnable task;
    private boolean firstRun = true;
    private long startTime;
    private long lastRun = 0L;
    private static final Logger log = LoggerFactory.getLogger(PeriodicTask.class);

    protected PeriodicTask(ApplicationInstance app, int initialDelay, int interval, boolean once, Runnable task) {
        this.initialDelay = initialDelay;
        this.taskQueue = new RestartableTaskQueue(app, interval, false, TaskQueues.QueueMode.DISCARD);
        this.once = once;
        this.task = task;
    }

    @Override
    public synchronized boolean start() {
        boolean started = this.taskQueue.start();
        if (started) {
            this.startTime = System.currentTimeMillis();
            this.lastRun = 0L;
            this.queue();
        }
        log.debug("Started PeriodicTask: {}", (Object)started);
        return started;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public synchronized boolean stop() {
        boolean stopped = this.taskQueue.stop();
        log.debug("Stopped PeriodicTask: {}", (Object)stopped);
        return stopped;
    }

    @Override
    public synchronized void dispose() {
        this.stop();
        this.taskQueue.dispose();
        this.task = null;
        log.debug("Disposed PeriodicTask");
    }

    @Override
    public synchronized boolean isRunning() {
        return this.taskQueue.isRunning();
    }

    private void queue() {
        if (this.taskQueue.isRunning()) {
            this.taskQueue.queue(this::execute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        Runnable runnable;
        PeriodicTask periodicTask = this;
        synchronized (periodicTask) {
            runnable = this.task;
        }
        boolean run = false;
        if (runnable != null && this.shouldRun()) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                log.warn("Task execution failed", (Throwable)exception);
            }
            this.lastRun = System.currentTimeMillis();
            run = true;
        }
        if (run && this.once) {
            this.dispose();
        } else {
            this.queue();
        }
    }

    private boolean shouldRun() {
        boolean run = false;
        int interval = this.taskQueue.getInterval();
        if (this.firstRun) {
            if (this.initialDelay > 0) {
                long diff = this.getDiffToNow(this.startTime);
                if (diff >= (long)this.initialDelay) {
                    run = true;
                    this.firstRun = false;
                    log.debug("Running task after initialDelay of {}s expired {}s ago", (Object)this.initialDelay, (Object)(diff - (long)this.initialDelay));
                } else {
                    log.debug("Not running task as initialDelay of {}s has not expired yet. Elapsed={}s", (Object)this.initialDelay, (Object)diff);
                }
            } else {
                log.debug("Running PeriodicTask for first time");
                run = true;
                this.firstRun = false;
            }
        } else {
            long diff = this.getDiffToNow(this.lastRun);
            if (this.lastRun == 0L) {
                log.debug("Running PeriodicTask");
                run = true;
            } else if (diff >= (long)interval) {
                log.debug("Running PeriodicTask. It is scheduled to run every {}s, and last ran {}s ago", (Object)interval, (Object)diff);
                run = true;
            } else {
                log.debug("Not running PeriodicTask. It is scheduled to run every {}s, but last ran {}s ago", (Object)interval, (Object)diff);
            }
        }
        return run;
    }

    private long getDiffToNow(long time) {
        return (System.currentTimeMillis() - time) / 1000L;
    }
}

