/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.util;

import nextapp.echo2.app.ApplicationInstance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.util.TaskQueue;
import org.openvpms.web.echo.util.TaskQueues;

public abstract class ApplicationInstanceFunctor {
    private final TaskQueue taskQueue;
    private static final Log log = LogFactory.getLog(ApplicationInstanceFunctor.class);

    public ApplicationInstanceFunctor(int interval, TaskQueues.QueueMode queueMode) {
        SpringApplicationInstance app = (SpringApplicationInstance)ApplicationInstance.getActive();
        if (app == null) {
            throw new IllegalStateException("No current ApplicationInstance");
        }
        this.taskQueue = app.getTaskQueues().newQueue(interval, queueMode);
    }

    public void dispose() {
        this.taskQueue.dispose();
    }

    protected void enqueueTask(Runnable task) {
        this.taskQueue.queue(() -> {
            try {
                task.run();
            }
            catch (Exception exception) {
                log.warn((Object)"ApplicationInstanceFunctor callback threw exception", (Throwable)exception);
            }
        });
    }
}

