/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.text;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.update.ServerComponentUpdate;
import nextapp.echo2.webcontainer.ContainerInstance;
import nextapp.echo2.webcontainer.RenderContext;
import nextapp.echo2.webcontainer.propertyrender.ExtentRender;
import nextapp.echo2.webrender.ServerMessage;
import nextapp.echo2.webrender.Service;
import nextapp.echo2.webrender.WebRenderServlet;
import nextapp.echo2.webrender.output.CssStyle;
import nextapp.echo2.webrender.servermessage.DomUpdate;
import nextapp.echo2.webrender.service.JavaScriptService;
import org.openvpms.web.echo.text.SMSTextArea;
import org.openvpms.web.echo.text.TextArea;
import org.openvpms.web.echo.text.TextAreaPeer;
import org.openvpms.web.echo.text.TextComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SMSTextAreaPeer
extends TextAreaPeer {
    static final Service SERVICE = JavaScriptService.forResource((String)"SMSTextArea", (String)"/org/openvpms/web/echo/js/SMSTextArea.js");

    @Override
    public void renderHtml(RenderContext rc, ServerComponentUpdate addUpdate, Node parentNode, Component component) {
        CssStyle cssStyle;
        String value;
        ServerMessage serverMessage = rc.getServerMessage();
        serverMessage.addLibrary(SERVICE.getId());
        serverMessage.addLibrary(TEXT_COMPONENT_SERVICE.getId());
        TextArea textArea = (TextArea)component;
        String elementId = ContainerInstance.getElementId((Component)component);
        Element container = parentNode.getOwnerDocument().createElement("div");
        container.setAttribute("id", elementId + "_container");
        Element textAreaElement = parentNode.getOwnerDocument().createElement("textarea");
        textAreaElement.setAttribute("id", elementId);
        if (textArea.isFocusTraversalParticipant()) {
            textAreaElement.setAttribute("tabindex", Integer.toString(textArea.getFocusTraversalIndex()));
        } else {
            textAreaElement.setAttribute("tabindex", "-1");
        }
        String toolTipText = (String)textArea.getRenderProperty("toolTipText");
        if (toolTipText != null) {
            textAreaElement.setAttribute("title", toolTipText);
        }
        if ((value = textArea.getText()) != null && !rc.getContainerInstance().getClientProperties().getBoolean("quirkTextareaContent")) {
            textAreaElement.appendChild(rc.getServerMessage().getDocument().createTextNode(value));
        }
        if ((cssStyle = this.createBaseCssStyle(rc, textArea)).hasAttributes()) {
            textAreaElement.setAttribute("style", cssStyle.renderInline());
        }
        parentNode.appendChild(container);
        container.appendChild(textAreaElement);
        this.renderInitDirective(rc, textArea);
    }

    public void renderInitDirective(RenderContext rc, TextComponent textComponent) {
        Integer cursorPos;
        String value;
        Extent horizontalScroll = (Extent)textComponent.getRenderProperty("horizontalScroll");
        Extent verticalScroll = (Extent)textComponent.getRenderProperty("verticalScroll");
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("postupdate", "SMSTextArea.MessageProcessor", "init", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        if (horizontalScroll != null && horizontalScroll.getValue() != 0) {
            itemElement.setAttribute("horizontal-scroll", ExtentRender.renderCssAttributePixelValue((Extent)horizontalScroll, (String)"0"));
        }
        if (verticalScroll != null && verticalScroll.getValue() != 0) {
            itemElement.setAttribute("vertical-scroll", ExtentRender.renderCssAttributePixelValue((Extent)verticalScroll, (String)"0"));
        }
        int maxParts = ((SMSTextArea)textComponent).getMaxParts();
        itemElement.setAttribute("max-parts", Integer.toString(maxParts));
        if (rc.getContainerInstance().getClientProperties().getBoolean("quirkTextareaContent") && (value = textComponent.getText()) != null) {
            itemElement.setAttribute("text", value);
        }
        if ((cursorPos = (Integer)textComponent.getRenderProperty("cursorPosition")) != null) {
            itemElement.setAttribute("cursor-position", cursorPos.toString());
        }
        if (!textComponent.isRenderEnabled()) {
            itemElement.setAttribute("enabled", "false");
        }
        if (textComponent.hasActionListeners()) {
            itemElement.setAttribute("server-notify", "true");
        }
        itemizedUpdateElement.appendChild(itemElement);
    }

    @Override
    public void renderDispose(RenderContext rc, ServerComponentUpdate update, Component component) {
        rc.getServerMessage().addLibrary(SERVICE.getId());
        this.renderDisposeDirective(rc, (TextComponent)component);
    }

    public void renderDisposeDirective(RenderContext rc, TextComponent textComponent) {
        String elementId = ContainerInstance.getElementId((Component)textComponent);
        ServerMessage serverMessage = rc.getServerMessage();
        Element itemizedUpdateElement = serverMessage.getItemizedDirective("preremove", "SMSTextArea.MessageProcessor", "dispose", new String[0], new String[0]);
        Element itemElement = serverMessage.getDocument().createElement("item");
        itemElement.setAttribute("eid", elementId);
        itemizedUpdateElement.appendChild(itemElement);
    }

    @Override
    public boolean renderUpdate(RenderContext rc, ServerComponentUpdate update, String targetId) {
        String elementId = ContainerInstance.getElementId((Component)update.getParent());
        String containerId = elementId + "_container";
        DomUpdate.renderElementRemove((ServerMessage)rc.getServerMessage(), (String)containerId);
        this.renderAdd(rc, update, targetId, update.getParent());
        return false;
    }

    static {
        WebRenderServlet.getServiceRegistry().add(SERVICE);
    }
}

