/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.echo.style;

import echopointng.util.ColorKit;
import java.util.HashMap;
import java.util.Map;
import nextapp.echo2.app.Color;
import org.openvpms.web.echo.colour.ColourHelper;

public class Theme {
    private final String id;
    private final String name;
    private final Map<String, String> properties;
    private static final String PRIMARY = "primary";
    private static final String SECONDARY = "secondary";
    private static final String PRIMARY_BACKGROUND = "theme.background";
    private static final String PRIMARY_FOREGROUND = "theme.foreground";
    private static final String SECONDARY_BACKGROUND = "theme.button.background";
    private static final String SECONDARY_FOREGROUND = "theme.button.foreground";
    private static final String ROLLOVER_BACKGROUND = "theme.button.rolloverBackground";
    private static final String ROLLOVER_FOREGROUND = "theme.button.rolloverForeground";
    private static final String ROLLOVER_BORDER = "theme.button.rolloverBorder";
    private static final String DISABLED_BACKGROUND = "theme.button.disabledBackground";
    private static final String DISABLED_FOREGROUND = "theme.button.disabledForeground";
    private static final String DISABLED_BORDER = "theme.button.disabledBorder";
    private static final String PRESSED_BACKGROUND = "theme.button.pressedBackground";
    private static final String PRESSED_BORDER = "theme.button.pressedBorder";

    public Theme(String id, String name, Map<String, String> properties) {
        Color secondaryBackground;
        this.id = id;
        this.name = name;
        this.properties = new HashMap<String, String>(properties);
        this.rename(PRIMARY, PRIMARY_BACKGROUND);
        this.rename(SECONDARY, SECONDARY_BACKGROUND);
        Color primaryBackground = this.getColor(PRIMARY_BACKGROUND);
        if (primaryBackground != null) {
            this.addForeground(primaryBackground, PRIMARY_FOREGROUND);
            this.add(SECONDARY_BACKGROUND, ColorKit.brighter((Color)primaryBackground, (double)0.75));
        }
        if ((secondaryBackground = this.getColor(SECONDARY_BACKGROUND)) != null) {
            this.addForeground(secondaryBackground, SECONDARY_FOREGROUND);
            Color rolloverBackground = this.darken(secondaryBackground, ROLLOVER_BACKGROUND);
            Color rolloverBorder = ColorKit.darker((Color)rolloverBackground);
            this.add(ROLLOVER_BORDER, rolloverBorder);
            this.add(PRESSED_BORDER, rolloverBorder);
            this.add(PRESSED_BACKGROUND, rolloverBackground);
            Color disabled = this.add(DISABLED_BACKGROUND, ColorKit.brighter((Color)secondaryBackground, (double)0.9));
            if (!properties.containsKey(DISABLED_FOREGROUND)) {
                Color textColour = ColourHelper.getTextColour(disabled);
                textColour = textColour == Color.BLACK ? ColorKit.brighter((Color)textColour, (double)0.99) : ColorKit.darker((Color)textColour, (double)0.99);
                this.add(DISABLED_FOREGROUND, textColour);
            }
            this.add(DISABLED_BORDER, disabled);
        }
        this.addForeground(PRESSED_BACKGROUND, ROLLOVER_FOREGROUND);
        this.addForeground(ROLLOVER_BACKGROUND, ROLLOVER_FOREGROUND);
        this.addForeground(DISABLED_BACKGROUND, DISABLED_FOREGROUND);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, String> getExpressions() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String value = entry.getValue();
            if (value.startsWith("#")) {
                value = "'" + value + "'";
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public Color getColor() {
        return this.getColor(PRIMARY_BACKGROUND);
    }

    private Color darken(Color colour, String property) {
        Color result = this.getColor(property);
        if (result == null) {
            result = ColorKit.darker((Color)colour, (double)0.9);
            this.properties.put(property, ColorKit.makeCSSColor((Color)result));
        }
        return result;
    }

    private void rename(String source, String target) {
        if (this.properties.containsKey(source)) {
            if (!this.properties.containsKey(target)) {
                this.properties.put(target, this.properties.get(source));
            }
            this.properties.remove(source);
        }
    }

    private Color add(String property, Color colour) {
        Color result = this.getColor(property);
        if (result == null) {
            this.properties.put(property, ColorKit.makeCSSColor((Color)colour));
            result = colour;
        }
        return result;
    }

    private void addForeground(String background, String foreground) {
        Color colour = this.getColor(foreground);
        if (colour == null && (colour = this.getColor(background)) != null) {
            this.addForeground(colour, foreground);
        }
    }

    private void addForeground(Color colour, String foreground) {
        if (this.getColor(foreground) == null) {
            this.properties.put(foreground, ColorKit.makeCSSColor((Color)ColourHelper.getTextColour(colour)));
        }
    }

    private Color getColor(String property) {
        String code = this.properties.get(property);
        Color result = null;
        if (code != null) {
            try {
                result = ColorKit.makeColor((String)code);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }
}

